'use strict'

jQuery(document).ready(function ($) {

    $.fn.wowFullEditor = function () {
        this.each(function (index, element) {
            let parentEditor = $(element).closest('.wp-editor-container');
            if (parentEditor.length) {
                return;
            }

            const newId = 'wpie-fulleditor-' + (index + 1);
            $(element).attr('id', newId);
            $(element).css({'border': 'none', 'width': '100%'});
            wp.editor.initialize(
                newId,
                {
                    tinymce: {
                        wpautop: true,
                        plugins: 'textcolor colorpicker wplink wordpress',
                        toolbar1: 'bold italic underline blockquote | alignleft aligncenter alignright | bullist numlist outdent indent | link unlink | wp_more | fullscreen',
                        toolbar2: 'formatselect strikethrough hr forecolor pastetext removeformat charmap undo redo',
                    },
                    quicktags: {
                        buttons: "strong,em,link,block,del,ins,img,ul,ol,li,code,more,close,fullscreen"
                    },
                    mediaButtons: true,
                }
            );
        });
    };

    $.fn.wowTextEditor = function () {
        this.each(function (index, element) {
            let parentEditor = $(element).closest('.wp-editor-container');
            if (parentEditor.length) {
                return;
            }

            const newId = 'wpie-shorteditor-' + (index + 1);
            $(element).attr('id', newId);
            $(element).css({'border-top': 'none', 'min-height': '2'});

            wp.editor.initialize(newId, {
                tinymce: false, // This disables Visual mode
                quicktags: {
                    buttons: "strong,em,link,block,del,ins,img,ul,ol,li,code,more,close,fullscreen"
                },
                mediaButtons: false,
            });
        });
    };

    const icons = {
        'Accessibility': ['fas fa-circle-info', 'fas fa-eye', 'far fa-eye', 'fas fa-question', 'fas fa-phone-volume', 'fas fa-address-card', 'far fa-address-card', 'fas fa-tty', 'fas fa-hands', 'fas fa-audio-description', 'fas fa-closed-captioning', 'far fa-closed-captioning', 'fas fa-fingerprint', 'fas fa-wheelchair-move', 'fas fa-wheelchair', 'fas fa-universal-access', 'fas fa-person-walking-with-cane', 'fas fa-person-cane', 'fas fa-handshake-angle', 'fas fa-hands-asl-interpreting', 'fas fa-eye-low-vision', 'fas fa-ear-listen', 'fas fa-ear-deaf', 'fas fa-circle-question', 'fas fa-braille', 'far fa-circle-question',],
        'Alert': ['fas fa-bell', 'far fa-bell', 'fas fa-circle-exclamation', 'fas fa-question', 'fas fa-exclamation', 'fas fa-triangle-exclamation', 'fas fa-skull-crossbones', 'fas fa-radiation', 'fas fa-circle-radiation', 'fas fa-bell-slash', 'far fa-bell-slash',],
        'Alphabet': ['fas fa-address-card', 'far fa-address-card', 'fas fa-z', 'fas fa-y', 'fas fa-x', 'fas fa-w', 'fas fa-v', 'fas fa-u', 'fas fa-t', 'fas fa-square-h', 'fas fa-s', 'fas fa-r', 'fas fa-q', 'fas fa-p', 'fas fa-o', 'fas fa-n', 'fas fa-m', 'fas fa-l', 'fas fa-k', 'fas fa-j', 'fas fa-i', 'fas fa-h', 'fas fa-g', 'fas fa-f', 'fas fa-e', 'fas fa-d', 'fas fa-circle-h', 'fas fa-c', 'fas fa-b', 'fas fa-a',],
        'Animals': ['fas fa-hippo', 'fas fa-feather', 'fas fa-fish', 'fas fa-dragon', 'fas fa-otter', 'fas fa-kiwi-bird', 'fas fa-worm', 'fas fa-spider', 'fas fa-shrimp', 'fas fa-shield-dog', 'fas fa-shield-cat', 'fas fa-paw', 'fas fa-mosquito', 'fas fa-locust', 'fas fa-horse-head', 'fas fa-horse', 'fas fa-frog', 'fas fa-fish-fins', 'fas fa-feather-pointed', 'fas fa-dove', 'fas fa-dog', 'fas fa-crow', 'fas fa-cow', 'fas fa-cat', 'fas fa-bugs',],
        'Arrows': ['fas fa-download', 'fas fa-arrow-right', 'fas fa-caret-up', 'fas fa-arrow-up', 'fas fa-arrow-up-from-bracket', 'fas fa-circle-up', 'far fa-circle-up', 'fas fa-circle-down', 'far fa-circle-down', 'fas fa-rotate-right', 'fas fa-share-from-square', 'far fa-share-from-square', 'fas fa-share', 'fas fa-right-to-bracket', 'fas fa-cloud-arrow-up', 'fas fa-chevron-up', 'fas fa-upload', 'fas fa-sort', 'fas fa-angle-up', 'fas fa-arrow-down', 'fas fa-caret-down', 'fas fa-arrow-up-right-from-square', 'fas fa-arrow-left', 'fas fa-repeat', 'fas fa-reply', 'fas fa-recycle', 'fas fa-chevron-down', 'fas fa-up-right-from-square', 'fas fa-up-right-and-down-left-from-center', 'fas fa-up-long', 'fas fa-up-down-left-right', 'fas fa-up-down', 'fas fa-turn-up', 'fas fa-turn-down', 'fas fa-square-up-right', 'fas fa-square-caret-up', 'fas fa-square-caret-right', 'fas fa-square-caret-left', 'fas fa-square-caret-down', 'fas fa-square-arrow-up-right', 'fas fa-sort-up', 'fas fa-sort-down', 'fas fa-shuffle', 'fas fa-rotate-left', 'fas fa-rotate', 'fas fa-right-long', 'fas fa-right-left', 'fas fa-right-from-bracket', 'fas fa-retweet', 'fas fa-reply-all', 'fas fa-maximize', 'fas fa-location-arrow', 'fas fa-left-right', 'fas fa-left-long', 'fas fa-down-long', 'fas fa-down-left-and-up-right-to-center', 'fas fa-cloud-arrow-down', 'fas fa-clock-rotate-left', 'fas fa-circle-right', 'fas fa-circle-left', 'fas fa-circle-chevron-up', 'fas fa-circle-chevron-right', 'fas fa-circle-chevron-left', 'fas fa-circle-chevron-down', 'fas fa-circle-arrow-up', 'fas fa-circle-arrow-right', 'fas fa-circle-arrow-left', 'fas fa-circle-arrow-down', 'fas fa-chevron-right', 'fas fa-chevron-left', 'fas fa-caret-right', 'fas fa-caret-left', 'fas fa-arrows-up-to-line', 'fas fa-arrows-up-down-left-right', 'fas fa-arrows-up-down', 'fas fa-arrows-turn-to-dots', 'fas fa-arrows-turn-right', 'fas fa-arrows-to-eye', 'fas fa-arrows-to-dot', 'fas fa-arrows-to-circle', 'fas fa-arrows-split-up-and-left', 'fas fa-arrows-spin', 'fas fa-arrows-rotate', 'fas fa-arrows-left-right-to-line', 'fas fa-arrows-left-right', 'fas fa-arrows-down-to-line', 'fas fa-arrow-up-z-a', 'fas fa-arrow-up-wide-short', 'fas fa-arrow-up-short-wide', 'fas fa-arrow-up-right-dots', 'fas fa-arrow-up-long', 'fas fa-arrow-up-a-z', 'fas fa-arrow-up-9-1', 'fas fa-arrow-up-1-9', 'fas fa-arrow-turn-up', 'fas fa-arrow-turn-down', 'fas fa-arrow-trend-up', 'fas fa-arrow-trend-down', 'fas fa-arrow-rotate-right', 'fas fa-arrow-rotate-left', 'fas fa-arrow-right-to-bracket', 'fas fa-arrow-right-long', 'fas fa-arrow-right-from-bracket', 'fas fa-arrow-right-arrow-left', 'fas fa-arrow-pointer', 'fas fa-arrow-left-long', 'fas fa-arrow-down-z-a', 'fas fa-arrow-down-wide-short', 'fas fa-arrow-down-up-lock', 'fas fa-arrow-down-up-across-line', 'fas fa-arrow-down-short-wide', 'fas fa-arrow-down-long', 'fas fa-arrow-down-a-z', 'fas fa-arrow-down-9-1', 'fas fa-arrow-down-1-9', 'fas fa-angles-up', 'fas fa-angles-right', 'fas fa-angles-left', 'fas fa-angles-down', 'fas fa-angle-right', 'fas fa-angle-left', 'fas fa-angle-down', 'far fa-square-caret-up', 'far fa-square-caret-right', 'far fa-square-caret-left', 'far fa-square-caret-down', 'far fa-circle-right', 'far fa-circle-left',],
        'Astronomy': ['fas fa-globe', 'fas fa-binoculars', 'fas fa-moon', 'far fa-moon', 'fas fa-user-astronaut', 'fas fa-shuttle-space', 'fas fa-satellite-dish', 'fas fa-satellite', 'fas fa-meteor',],
        'Automotive': ['fas fa-car', 'fas fa-truck', 'fas fa-gauge', 'fas fa-car-side', 'fas fa-motorcycle', 'fas fa-truck-monster', 'fas fa-van-shuttle', 'fas fa-truck-pickup', 'fas fa-truck-medical', 'fas fa-truck-field-un', 'fas fa-truck-field', 'fas fa-trailer', 'fas fa-taxi', 'fas fa-spray-can-sparkles', 'fas fa-oil-can', 'fas fa-gauge-simple-high', 'fas fa-gauge-simple', 'fas fa-gauge-high', 'fas fa-gas-pump', 'fas fa-charging-station', 'fas fa-caravan', 'fas fa-car-tunnel', 'fas fa-car-rear', 'fas fa-car-on', 'fas fa-car-burst', 'fas fa-car-battery', 'fas fa-bus-simple', 'fas fa-bus',],
        'Brands': ['fab fa-facebook', 'fab fa-twitter', 'fab fa-instagram', 'fab fa-tiktok', 'fab fa-linkedin', 'fab fa-github', 'fab fa-discord', 'fab fa-youtube', 'fab fa-wordpress', 'fab fa-slack', 'fab fa-figma', 'fab fa-apple', 'fab fa-google', 'fab fa-stripe', 'fab fa-algolia', 'fab fa-docker', 'fab fa-windows', 'fab fa-paypal', 'fab fa-stack-overflow', 'fab fa-kickstarter', 'fab fa-dribbble', 'fab fa-dropbox', 'fab fa-squarespace', 'fab fa-android', 'fab fa-shopify', 'fab fa-medium', 'fab fa-codepen', 'fab fa-cloudflare', 'fab fa-airbnb', 'fab fa-vimeo', 'fab fa-whatsapp', 'fab fa-intercom', 'fab fa-usps', 'fab fa-wix', 'fab fa-line', 'fab fa-behance', 'fab fa-openid', 'fab fa-product-hunt', 'fab fa-internet-explorer', 'fab fa-pagelines', 'fab fa-teamspeak', 'fab fa-html5', 'fab fa-telegram', 'fab fa-pinterest', 'fab fa-dashcube', 'fab fa-ideal', 'fab fa-salesforce', 'fab fa-readme', 'fab fa-free-code-camp', 'fab fa-soundcloud', 'fab fa-square-twitter', 'fab fa-accessible-icon', 'fab fa-cc-visa', 'fab fa-goodreads-g', 'fab fa-google-play', 'fab fa-react', 'fab fa-wikipedia-w', 'fab fa-square-js', 'fab fa-java', 'fab fa-square-pinterest', 'fab fa-python', 'fab fa-skype', 'fab fa-linux', 'fab fa-node', 'fab fa-rebel', 'fab fa-etsy', 'fab fa-discourse', 'fab fa-amazon', 'fab fa-glide-g', 'fab fa-gitlab', 'fab fa-spotify', 'fab fa-think-peaks', 'fab fa-microsoft', 'fab fa-elementor', 'fab fa-pied-piper', 'fab fa-square-youtube', 'fab fa-cc-mastercard', 'fab fa-facebook-messenger', 'fab fa-atlassian', 'fab fa-playstation', 'fab fa-fly', 'fab fa-meetup', 'fab fa-twitch', 'fab fa-waze', 'fab fa-zhihu', 'fab fa-yoast', 'fab fa-yelp', 'fab fa-yarn', 'fab fa-yandex-international', 'fab fa-yandex', 'fab fa-yammer', 'fab fa-yahoo', 'fab fa-y-combinator', 'fab fa-xing', 'fab fa-xbox', 'fab fa-x-twitter', 'fab fa-wpressr', 'fab fa-wpforms', 'fab fa-wpexplorer', 'fab fa-wpbeginner', 'fab fa-wordpress-simple', 'fab fa-wolf-pack-battalion', 'fab fa-wodu', 'fab fa-wizards-of-the-coast', 'fab fa-wirsindhandwerk', 'fab fa-whmcs', 'fab fa-weixin', 'fab fa-weibo', 'fab fa-weebly', 'fab fa-webflow', 'fab fa-web-awesome', 'fab fa-watchman-monitoring', 'fab fa-vuejs', 'fab fa-vnv', 'fab fa-vk', 'fab fa-vine', 'fab fa-vimeo-v', 'fab fa-viber', 'fab fa-viadeo', 'fab fa-viacoin', 'fab fa-vaadin', 'fab fa-ussunnah', 'fab fa-usb', 'fab fa-upwork', 'fab fa-ups', 'fab fa-untappd', 'fab fa-unsplash', 'fab fa-unity', 'fab fa-uniregistry', 'fab fa-uncharted', 'fab fa-umbraco', 'fab fa-uikit', 'fab fa-ubuntu', 'fab fa-uber', 'fab fa-typo3', 'fab fa-tumblr', 'fab fa-trello', 'fab fa-trade-federation', 'fab fa-threads', 'fab fa-themeisle', 'fab fa-themeco', 'fab fa-the-red-yeti', 'fab fa-tencent-weibo', 'fab fa-symfony', 'fab fa-swift', 'fab fa-suse', 'fab fa-supple', 'fab fa-superpowers', 'fab fa-stumbleupon-circle', 'fab fa-stumbleupon', 'fab fa-studiovinari', 'fab fa-stubber', 'fab fa-stripe-s', 'fab fa-strava', 'fab fa-sticker-mule', 'fab fa-steam-symbol', 'fab fa-steam', 'fab fa-staylinked', 'fab fa-stackpath', 'fab fa-stack-exchange', 'fab fa-square-xing', 'fab fa-square-x-twitter', 'fab fa-square-whatsapp', 'fab fa-square-web-awesome-stroke', 'fab fa-square-web-awesome', 'fab fa-square-vimeo', 'fab fa-square-viadeo', 'fab fa-square-upwork', 'fab fa-square-tumblr', 'fab fa-square-threads', 'fab fa-square-steam', 'fab fa-square-snapchat', 'fab fa-square-reddit', 'fab fa-square-pied-piper', 'fab fa-square-odnoklassniki', 'fab fa-square-letterboxd', 'fab fa-square-lastfm', 'fab fa-square-instagram', 'fab fa-square-hacker-news', 'fab fa-square-google-plus', 'fab fa-square-gitlab', 'fab fa-square-github', 'fab fa-square-git', 'fab fa-square-font-awesome-stroke', 'fab fa-square-font-awesome', 'fab fa-square-facebook', 'fab fa-square-dribbble', 'fab fa-square-behance', 'fab fa-speaker-deck', 'fab fa-speakap', 'fab fa-space-awesome', 'fab fa-sourcetree', 'fab fa-snapchat', 'fab fa-slideshare', 'fab fa-skyatlas', 'fab fa-sketch', 'fab fa-sitrox', 'fab fa-sith', 'fab fa-sistrix', 'fab fa-simplybuilt', 'fab fa-signal-messenger', 'fab fa-shopware', 'fab fa-shoelace', 'fab fa-shirtsinbulk', 'fab fa-servicestack', 'fab fa-sellsy', 'fab fa-sellcast', 'fab fa-searchengin', 'fab fa-scribd', 'fab fa-screenpal', 'fab fa-schlix', 'fab fa-sass', 'fab fa-safari', 'fab fa-rust', 'fab fa-rockrms', 'fab fa-rocketchat', 'fab fa-rev', 'fab fa-resolving', 'fab fa-researchgate', 'fab fa-replyd', 'fab fa-renren', 'fab fa-redhat', 'fab fa-reddit-alien', 'fab fa-reddit', 'fab fa-red-river', 'fab fa-reacteurope', 'fab fa-ravelry', 'fab fa-raspberry-pi', 'fab fa-r-project', 'fab fa-quora', 'fab fa-quinscape', 'fab fa-qq', 'fab fa-pushed', 'fab fa-pixiv', 'fab fa-pix', 'fab fa-pinterest-p', 'fab fa-pied-piper-pp', 'fab fa-pied-piper-hat', 'fab fa-pied-piper-alt', 'fab fa-php', 'fab fa-phoenix-squadron', 'fab fa-phoenix-framework', 'fab fa-phabricator', 'fab fa-periscope', 'fab fa-perbyte', 'fab fa-patreon', 'fab fa-palfed', 'fab fa-page4', 'fab fa-padlet', 'fab fa-osi', 'fab fa-orcid', 'fab fa-optin-monster', 'fab fa-opera', 'fab fa-opensuse', 'fab fa-opencart', 'fab fa-old-republic', 'fab fa-odysee', 'fab fa-odnoklassniki', 'fab fa-octopus-deploy', 'fab fa-nutritionix', 'fab fa-ns8', 'fab fa-npm', 'fab fa-node-js', 'fab fa-nimblr', 'fab fa-nfc-symbol', 'fab fa-nfc-directional', 'fab fa-neos', 'fab fa-napster', 'fab fa-monero', 'fab fa-modx', 'fab fa-mizuni', 'fab fa-mixer', 'fab fa-mixcloud', 'fab fa-mix', 'fab fa-mintbit', 'fab fa-microblog', 'fab fa-meta', 'fab fa-mendeley', 'fab fa-megaport', 'fab fa-medrt', 'fab fa-medapps', 'fab fa-mdb', 'fab fa-maxcdn', 'fab fa-mastodon', 'fab fa-markdown', 'fab fa-mandalorian', 'fab fa-mailchimp', 'fab fa-magento', 'fab fa-lyft', 'fab fa-linode', 'fab fa-linkedin-in', 'fab fa-letterboxd', 'fab fa-less', 'fab fa-leanpub', 'fab fa-lastfm', 'fab fa-laravel', 'fab fa-korvue', 'fab fa-kickstarter-k', 'fab fa-keycdn', 'fab fa-keybase', 'fab fa-kaggle', 'fab fa-jxl', 'fab fa-jsfiddle', 'fab fa-js', 'fab fa-joomla', 'fab fa-joget', 'fab fa-jira', 'fab fa-jenkins', 'fab fa-jedi-order', 'fab fa-itunes-note', 'fab fa-itunes', 'fab fa-itch-io', 'fab fa-ioxhost', 'fab fa-invision', 'fab fa-instalod', 'fab fa-imdb', 'fab fa-hubspot', 'fab fa-houzz', 'fab fa-hotjar', 'fab fa-hornbill', 'fab fa-hooli', 'fab fa-hive', 'fab fa-hire-a-helper', 'fab fa-hips', 'fab fa-hashnode', 'fab fa-hackerrank', 'fab fa-hacker-news', 'fab fa-gulp', 'fab fa-guilded', 'fab fa-grunt', 'fab fa-gripfire', 'fab fa-grav', 'fab fa-gratipay', 'fab fa-google-wallet', 'fab fa-google-scholar', 'fab fa-google-plus-g', 'fab fa-google-plus', 'fab fa-google-pay', 'fab fa-google-drive', 'fab fa-goodreads', 'fab fa-golang', 'fab fa-gofore', 'fab fa-glide', 'fab fa-gitter', 'fab fa-gitkraken', 'fab fa-github-alt', 'fab fa-git-alt', 'fab fa-git', 'fab fa-gg-circle', 'fab fa-gg', 'fab fa-get-pocket', 'fab fa-galactic-senate', 'fab fa-galactic-republic', 'fab fa-fulcrum', 'fab fa-freebsd', 'fab fa-foursquare', 'fab fa-forumbee', 'fab fa-fort-awesome-alt', 'fab fa-fort-awesome', 'fab fa-fonticons-fi', 'fab fa-fonticons', 'fab fa-font-awesome', 'fab fa-flutter', 'fab fa-flipboard', 'fab fa-flickr', 'fab fa-firstdraft', 'fab fa-first-order-alt', 'fab fa-first-order', 'fab fa-firefox-browser', 'fab fa-firefox', 'fab fa-fedora', 'fab fa-fedex', 'fab fa-fantasy-flight-games', 'fab fa-facebook-f', 'fab fa-expeditedssl', 'fab fa-evernote', 'fab fa-ethereum', 'fab fa-erlang', 'fab fa-envira', 'fab fa-empire', 'fab fa-ember', 'fab fa-ello', 'fab fa-edge-legacy', 'fab fa-edge', 'fab fa-ebay', 'fab fa-earlybirds', 'fab fa-dyalog', 'fab fa-drupal', 'fab fa-draft2digital', 'fab fa-dochub', 'fab fa-digital-ocean', 'fab fa-digg', 'fab fa-diaspora', 'fab fa-dhl', 'fab fa-deviantart', 'fab fa-dev', 'fab fa-deskpro', 'fab fa-deploydog', 'fab fa-delicious', 'fab fa-deezer', 'fab fa-debian', 'fab fa-dart-lang', 'fab fa-dailymotion', 'fab fa-d-and-d-beyond', 'fab fa-d-and-d', 'fab fa-cuttlefish', 'fab fa-css3-alt', 'fab fa-css3', 'fab fa-css', 'fab fa-critical-role', 'fab fa-creative-commons-zero', 'fab fa-creative-commons-share', 'fab fa-creative-commons-sampling-plus', 'fab fa-creative-commons-sampling', 'fab fa-creative-commons-sa', 'fab fa-creative-commons-remix', 'fab fa-creative-commons-pd-alt', 'fab fa-creative-commons-pd', 'fab fa-creative-commons-nd', 'fab fa-creative-commons-nc-jp', 'fab fa-creative-commons-nc-eu', 'fab fa-creative-commons-nc', 'fab fa-creative-commons-by', 'fab fa-creative-commons', 'fab fa-cpanel', 'fab fa-cotton-bureau', 'fab fa-contao', 'fab fa-connectdevelop', 'fab fa-confluence', 'fab fa-codiepie', 'fab fa-cmplid', 'fab fa-cloudversify', 'fab fa-cloudsmith', 'fab fa-cloudscale', 'fab fa-chromecast', 'fab fa-chrome', 'fab fa-centos', 'fab fa-centercode', 'fab fa-cc-stripe', 'fab fa-cc-paypal', 'fab fa-cc-jcb', 'fab fa-cc-discover', 'fab fa-cc-diners-club', 'fab fa-cc-apple-pay', 'fab fa-cc-amex', 'fab fa-cc-amazon-pay', 'fab fa-canadian-maple-leaf', 'fab fa-buysellads', 'fab fa-buy-n-large', 'fab fa-buromobelexperte', 'fab fa-buffer', 'fab fa-btc', 'fab fa-brave-reverse', 'fab fa-brave', 'fab fa-bots', 'fab fa-bootstrap', 'fab fa-bluetooth-b', 'fab fa-bluetooth', 'fab fa-bluesky', 'fab fa-square-bluesky', 'fab fa-blogger-b', 'fab fa-blogger', 'fab fa-blackberry', 'fab fa-black-tie', 'fab fa-bity', 'fab fa-bitcoin', 'fab fa-bitbucket', 'fab fa-bimobject', 'fab fa-bilibili', 'fab fa-battle-net', 'fab fa-bandcamp', 'fab fa-aws', 'fab fa-aviato', 'fab fa-avianex', 'fab fa-autoprefixer', 'fab fa-audible', 'fab fa-asymmetrik', 'fab fa-artstation', 'fab fa-apple-pay', 'fab fa-apper', 'fab fa-app-store-ios', 'fab fa-app-store', 'fab fa-angular', 'fab fa-angrycreative', 'fab fa-angellist', 'fab fa-amilia', 'fab fa-amazon-pay', 'fab fa-alipay', 'fab fa-affiliatetheme', 'fab fa-adversal', 'fab fa-adn', 'fab fa-accusoft', 'fab fa-500px', 'fab fa-42-group',],
        'Buildings': ['fas fa-house', 'fas fa-city', 'fas fa-shop', 'fas fa-landmark', 'fas fa-building', 'far fa-building', 'fas fa-store', 'fas fa-school', 'fas fa-hotel', 'fas fa-place-of-worship', 'fas fa-hospital', 'far fa-hospital', 'fas fa-church', 'fas fa-warehouse', 'fas fa-gopuram', 'fas fa-industry', 'fas fa-vihara', 'fas fa-tree-city', 'fas fa-tower-observation', 'fas fa-torii-gate', 'fas fa-toilets-portable', 'fas fa-toilet-portable', 'fas fa-tents', 'fas fa-tent-arrows-down', 'fas fa-tent-arrow-turn-left', 'fas fa-tent-arrow-left-right', 'fas fa-tent-arrow-down-to-line', 'fas fa-tent', 'fas fa-synagogue', 'fas fa-shop-lock', 'fas fa-school-lock', 'fas fa-school-flag', 'fas fa-school-circle-xmark', 'fas fa-school-circle-exclamation', 'fas fa-school-circle-check', 'fas fa-oil-well', 'fas fa-mountain-city', 'fas fa-mosque', 'fas fa-monument', 'fas fa-landmark-flag', 'fas fa-landmark-dome', 'fas fa-kaaba', 'fas fa-igloo', 'fas fa-house-medical-flag', 'fas fa-house-medical-circle-xmark', 'fas fa-house-medical-circle-exclamation', 'fas fa-house-medical-circle-check', 'fas fa-house-medical', 'fas fa-house-lock', 'fas fa-house-flag', 'fas fa-house-fire', 'fas fa-house-crack', 'fas fa-house-circle-xmark', 'fas fa-house-circle-exclamation', 'fas fa-house-circle-check', 'fas fa-house-chimney-window', 'fas fa-house-chimney-medical', 'fas fa-house-chimney-crack', 'fas fa-house-chimney', 'fas fa-hospital-user', 'fas fa-dungeon', 'fas fa-campground', 'fas fa-building-wheat', 'fas fa-building-user', 'fas fa-building-un', 'fas fa-building-shield', 'fas fa-building-ngo', 'fas fa-building-lock', 'fas fa-building-flag', 'fas fa-building-columns', 'fas fa-building-circle-xmark', 'fas fa-building-circle-exclamation', 'fas fa-building-circle-check', 'fas fa-building-circle-arrow-right', 'fas fa-arrow-right-to-city', 'fas fa-archway',],
        'Business': ['fas fa-phone', 'fas fa-envelope', 'far fa-envelope', 'fas fa-pen-nib', 'fas fa-calendar-days', 'far fa-calendar-days', 'fas fa-paperclip', 'fas fa-file', 'far fa-file', 'fas fa-clipboard', 'far fa-clipboard', 'fas fa-pen', 'fas fa-tag', 'fas fa-book', 'fas fa-print', 'fas fa-pen-to-square', 'far fa-pen-to-square', 'fas fa-folder', 'far fa-folder', 'fas fa-folder-open', 'far fa-folder-open', 'fas fa-thumbtack', 'fas fa-globe', 'fas fa-city', 'fas fa-briefcase', 'fas fa-compass', 'far fa-compass', 'fas fa-address-book', 'far fa-address-book', 'fas fa-business-time', 'fas fa-pen-fancy', 'fas fa-mug-saucer', 'fas fa-landmark', 'fas fa-chart-simple', 'fas fa-calendar', 'far fa-calendar', 'fas fa-pencil', 'fas fa-phone-volume', 'fas fa-copy', 'far fa-copy', 'fas fa-table', 'fas fa-building', 'far fa-building', 'fas fa-network-wired', 'fas fa-address-card', 'far fa-address-card', 'fas fa-tags', 'fas fa-registered', 'far fa-registered', 'fas fa-signature', 'fas fa-sitemap', 'fas fa-marker', 'fas fa-wallet', 'fas fa-copyright', 'far fa-copyright', 'fas fa-bullseye', 'fas fa-calculator', 'fas fa-certificate', 'fas fa-percent', 'fas fa-eraser', 'fas fa-glasses', 'fas fa-industry', 'fas fa-vault', 'fas fa-trademark', 'fas fa-timeline', 'fas fa-thumbtack-slash', 'fas fa-table-columns', 'fas fa-stapler', 'fas fa-square-poll-vertical', 'fas fa-square-poll-horizontal', 'fas fa-square-phone-flip', 'fas fa-square-phone', 'fas fa-square-pen', 'fas fa-square-envelope', 'fas fa-socks', 'fas fa-scissors', 'fas fa-scale-unbalanced-flip', 'fas fa-scale-unbalanced', 'fas fa-scale-balanced', 'fas fa-phone-slash', 'fas fa-phone-flip', 'fas fa-person-chalkboard', 'fas fa-pen-clip', 'fas fa-paste', 'fas fa-note-sticky', 'fas fa-magnifying-glass-chart', 'fas fa-magnifying-glass-arrow-right', 'fas fa-list-check', 'fas fa-laptop-file', 'fas fa-house-laptop', 'fas fa-highlighter', 'fas fa-folder-tree', 'fas fa-folder-plus', 'fas fa-folder-minus', 'fas fa-floppy-disk', 'fas fa-file-lines', 'fas fa-file-circle-plus', 'fas fa-fax', 'fas fa-envelope-open', 'fas fa-envelope-circle-check', 'fas fa-clipboard-question', 'fas fa-chart-pie', 'fas fa-chart-line', 'fas fa-cake-candles', 'fas fa-bullhorn', 'fas fa-boxes-packing', 'fas fa-box-archive', 'fas fa-bars-staggered', 'fas fa-bars-progress', 'fas fa-arrows-to-eye', 'fas fa-arrows-to-dot', 'fas fa-arrows-spin', 'far fa-paste', 'far fa-note-sticky', 'far fa-floppy-disk', 'far fa-file-lines', 'far fa-envelope-open',],
        'Camping': ['fas fa-fire', 'fas fa-tree', 'fas fa-compass', 'far fa-compass', 'fas fa-binoculars', 'fas fa-mountain-sun', 'fas fa-route', 'fas fa-trailer', 'fas fa-toilet-paper', 'fas fa-tents', 'fas fa-tent-arrows-down', 'fas fa-tent-arrow-turn-left', 'fas fa-tent-arrow-left-right', 'fas fa-tent-arrow-down-to-line', 'fas fa-tent', 'fas fa-tarp-droplet', 'fas fa-tarp', 'fas fa-signs-post', 'fas fa-person-shelter', 'fas fa-person-hiking', 'fas fa-people-roof', 'fas fa-mountain', 'fas fa-mosquito-net', 'fas fa-mosquito', 'fas fa-mattress-pillow', 'fas fa-map-location-dot', 'fas fa-map-location', 'fas fa-map', 'fas fa-kit-medical', 'fas fa-frog', 'fas fa-fire-flame-curved', 'fas fa-fire-burner', 'fas fa-faucet-drip', 'fas fa-faucet', 'fas fa-caravan', 'fas fa-campground', 'fas fa-bucket', 'fas fa-bottle-water', 'far fa-map',],
        'Charity': ['fas fa-heart', 'far fa-heart', 'fas fa-gift', 'fas fa-globe', 'fas fa-handshake', 'far fa-handshake', 'fas fa-hand-holding-heart', 'fas fa-leaf', 'fas fa-seedling', 'fas fa-dollar-sign', 'fas fa-ribbon', 'fas fa-piggy-bank', 'fas fa-parachute-box', 'fas fa-handshake-simple', 'fas fa-handshake-angle', 'fas fa-hands-holding-circle', 'fas fa-hands-holding-child', 'fas fa-hand-holding-hand', 'fas fa-hand-holding-droplet', 'fas fa-hand-holding-dollar', 'fas fa-dove', 'fas fa-circle-dollar-to-slot',],
        'Charts+Diagrams': ['fas fa-circle-half-stroke', 'fas fa-chart-simple', 'fas fa-square-poll-vertical', 'fas fa-square-poll-horizontal', 'fas fa-diagram-successor', 'fas fa-diagram-project', 'fas fa-diagram-predecessor', 'fas fa-diagram-next', 'fas fa-chart-pie', 'fas fa-chart-line', 'fas fa-chart-gantt', 'fas fa-chart-column', 'fas fa-chart-bar', 'fas fa-chart-area', 'fas fa-bars-progress', 'far fa-chart-bar',],
        'Childhood': ['fas fa-bath', 'fas fa-gamepad', 'fas fa-school', 'fas fa-robot', 'fas fa-child', 'fas fa-baby', 'fas fa-puzzle-piece', 'fas fa-cookie-bite', 'fas fa-snowman', 'fas fa-shapes', 'fas fa-person-breastfeeding', 'fas fa-person-biking', 'fas fa-mitten', 'fas fa-ice-cream', 'fas fa-hands-holding-child', 'fas fa-cubes-stacked', 'fas fa-cookie', 'fas fa-children', 'fas fa-child-reaching', 'fas fa-child-dress', 'fas fa-cake-candles', 'fas fa-bucket', 'fas fa-baseball-bat-ball', 'fas fa-baby-carriage', 'fas fa-apple-whole',],
        'Clothing+Fashion': ['fas fa-shirt', 'fas fa-user-tie', 'fas fa-glasses', 'fas fa-vest-patches', 'fas fa-vest', 'fas fa-socks', 'fas fa-shoe-prints', 'fas fa-mitten', 'fas fa-hat-wizard', 'fas fa-hat-cowboy-side', 'fas fa-hat-cowboy', 'fas fa-graduation-cap',],
        'Coding': ['fas fa-bars', 'fas fa-shield-halved', 'fas fa-file', 'far fa-file', 'fas fa-filter', 'fas fa-gear', 'fas fa-barcode', 'fas fa-folder', 'far fa-folder', 'fas fa-folder-open', 'far fa-folder-open', 'fas fa-gears', 'fas fa-code', 'fas fa-bath', 'fas fa-bug', 'fas fa-mug-saucer', 'fas fa-code-compare', 'fas fa-user-secret', 'fas fa-network-wired', 'fas fa-shield', 'fas fa-sitemap', 'fas fa-microchip', 'fas fa-cube', 'fas fa-keyboard', 'far fa-keyboard', 'fas fa-code-branch', 'fas fa-window-restore', 'far fa-window-restore', 'fas fa-window-minimize', 'fas fa-window-maximize', 'fas fa-web-awesome', 'fas fa-terminal', 'fas fa-rectangle-xmark', 'fas fa-qrcode', 'fas fa-notdef', 'fas fa-laptop-code', 'fas fa-font-awesome', 'fas fa-fire-extinguisher', 'fas fa-file-lines', 'fas fa-file-code', 'fas fa-diagram-project', 'fas fa-cubes', 'fas fa-code-pull-request', 'fas fa-code-merge', 'fas fa-code-fork', 'fas fa-code-commit', 'fas fa-circle-nodes', 'fas fa-bug-slash', 'fas fa-box-archive', 'fas fa-bars-staggered', 'fab fa-web-awesome', 'fab fa-font-awesome', 'far fa-window-minimize', 'far fa-window-maximize', 'far fa-rectangle-xmark', 'far fa-font-awesome', 'far fa-file-lines', 'far fa-file-code',],
        'Communication': ['fas fa-phone', 'fas fa-envelope', 'far fa-envelope', 'fas fa-poo', 'fas fa-comment', 'far fa-comment', 'fas fa-face-smile', 'far fa-face-smile', 'fas fa-inbox', 'fas fa-video', 'fas fa-comments', 'far fa-comments', 'fas fa-paper-plane', 'far fa-paper-plane', 'fas fa-address-book', 'far fa-address-book', 'fas fa-quote-left', 'fas fa-phone-volume', 'fas fa-mobile', 'fas fa-address-card', 'far fa-address-card', 'fas fa-quote-right', 'fas fa-video-slash', 'fas fa-tty', 'fas fa-icons', 'fas fa-language', 'fas fa-walkie-talkie', 'fas fa-voicemail', 'fas fa-microphone-slash', 'fas fa-microphone', 'fas fa-tower-cell', 'fas fa-square-rss', 'fas fa-square-phone-flip', 'fas fa-square-phone', 'fas fa-square-envelope', 'fas fa-phone-slash', 'fas fa-phone-flip', 'fas fa-mobile-screen-button', 'fas fa-mobile-screen', 'fas fa-mobile-retro', 'fas fa-mobile-button', 'fas fa-microphone-lines-slash', 'fas fa-microphone-lines', 'fas fa-message', 'fas fa-hands-asl-interpreting', 'fas fa-fax', 'fas fa-face-meh', 'fas fa-face-frown', 'fas fa-envelope-open', 'fas fa-envelope-circle-check', 'fas fa-ear-listen', 'fas fa-comment-sms', 'fas fa-comment-slash', 'fas fa-comment-medical', 'fas fa-comment-dots', 'fas fa-bullhorn', 'fas fa-blender-phone', 'fas fa-at', 'fab fa-bluetooth-b', 'far fa-message', 'far fa-face-meh', 'far fa-face-frown', 'far fa-envelope-open', 'far fa-comment-dots',],
        'Connectivity': ['fas fa-cloud', 'fas fa-globe', 'fas fa-wifi', 'fas fa-cloud-arrow-up', 'fas fa-signal', 'fas fa-tower-cell', 'fas fa-tower-broadcast', 'fas fa-satellite-dish', 'fas fa-rss', 'fas fa-house-signal', 'fas fa-ethernet', 'fas fa-cloud-arrow-down', 'fas fa-circle-nodes', 'fab fa-bluetooth',],
        'Construction': ['fas fa-paint-roller', 'fas fa-brush', 'fas fa-dumpster-fire', 'fas fa-pencil', 'fas fa-wrench', 'fas fa-hammer', 'fas fa-ruler', 'fas fa-ruler-vertical', 'fas fa-truck-pickup', 'fas fa-trowel-bricks', 'fas fa-trowel', 'fas fa-toolbox', 'fas fa-toilets-portable', 'fas fa-toilet-portable', 'fas fa-tarp-droplet', 'fas fa-tarp', 'fas fa-sheet-plastic', 'fas fa-screwdriver-wrench', 'fas fa-screwdriver', 'fas fa-ruler-horizontal', 'fas fa-ruler-combined', 'fas fa-person-digging', 'fas fa-pen-ruler', 'fas fa-mound', 'fas fa-helmet-safety', 'fas fa-dumpster', 'fas fa-compass-drafting', 'fas fa-bucket', 'fas fa-bore-hole', 'fas fa-arrow-up-from-ground-water',],
        'Design': ['fas fa-wand-magic-sparkles', 'fas fa-pen-nib', 'fas fa-pen', 'fas fa-circle-half-stroke', 'fas fa-droplet', 'fas fa-pen-to-square', 'far fa-pen-to-square', 'fas fa-eye', 'far fa-eye', 'fas fa-eye-slash', 'far fa-eye-slash', 'fas fa-paint-roller', 'fas fa-brush', 'fas fa-palette', 'fas fa-layer-group', 'fas fa-pen-fancy', 'fas fa-pencil', 'fas fa-copy', 'far fa-copy', 'fas fa-icons', 'fas fa-marker', 'fas fa-cube', 'fas fa-crosshairs', 'fas fa-clone', 'far fa-clone', 'fas fa-eraser', 'fas fa-ruler-vertical', 'fas fa-stamp', 'fas fa-web-awesome', 'fas fa-wand-magic', 'fas fa-vector-square', 'fas fa-swatchbook', 'fas fa-stapler', 'fas fa-spray-can', 'fas fa-splotch', 'fas fa-scissors', 'fas fa-ruler-horizontal', 'fas fa-ruler-combined', 'fas fa-pen-ruler', 'fas fa-pen-clip', 'fas fa-paste', 'fas fa-paintbrush', 'fas fa-object-ungroup', 'fas fa-object-group', 'fas fa-lines-leaning', 'fas fa-highlighter', 'fas fa-font-awesome', 'fas fa-floppy-disk', 'fas fa-fill-drip', 'fas fa-fill', 'fas fa-eye-dropper', 'fas fa-droplet-slash', 'fas fa-draw-polygon', 'fas fa-cubes', 'fas fa-crop-simple', 'fas fa-crop', 'fas fa-compass-drafting', 'fas fa-circle-nodes', 'fas fa-bezier-curve', 'fab fa-web-awesome', 'fab fa-font-awesome', 'far fa-paste', 'far fa-object-ungroup', 'far fa-object-group', 'far fa-font-awesome', 'far fa-floppy-disk',],
        'Devices+Hardware': ['fas fa-download', 'fas fa-camera-retro', 'fas fa-headphones', 'fas fa-print', 'fas fa-camera', 'fas fa-gamepad', 'fas fa-upload', 'fas fa-database', 'fas fa-mobile', 'fas fa-server', 'fas fa-laptop', 'fas fa-power-off', 'fas fa-desktop', 'fas fa-walkie-talkie', 'fas fa-microchip', 'fas fa-plug', 'fas fa-keyboard', 'far fa-keyboard', 'fas fa-tablet', 'fas fa-tv', 'fas fa-tachograph-digital', 'fas fa-tablet-screen-button', 'fas fa-tablet-button', 'fas fa-sim-card', 'fas fa-sd-card', 'fas fa-satellite-dish', 'fas fa-satellite', 'fas fa-mobile-screen-button', 'fas fa-mobile-screen', 'fas fa-mobile-retro', 'fas fa-mobile-button', 'fas fa-memory', 'fas fa-laptop-file', 'fas fa-house-laptop', 'fas fa-hard-drive', 'fas fa-floppy-disk', 'fas fa-fax', 'fas fa-ethernet', 'fas fa-display', 'fas fa-computer-mouse', 'fas fa-computer', 'fas fa-compact-disc', 'fas fa-car-battery', 'fas fa-blender-phone', 'far fa-hard-drive', 'far fa-floppy-disk',],
        'Disaster+Crisis': ['fas fa-snowflake', 'far fa-snowflake', 'fas fa-wind', 'fas fa-xmarks-lines', 'fas fa-worm', 'fas fa-wheat-awn-circle-exclamation', 'fas fa-volcano', 'fas fa-tornado', 'fas fa-temperature-arrow-up', 'fas fa-temperature-arrow-down', 'fas fa-sun-plant-wilt', 'fas fa-radiation', 'fas fa-plant-wilt', 'fas fa-person-walking-dashed-line-arrow-right', 'fas fa-person-walking-arrow-right', 'fas fa-person-walking-arrow-loop-left', 'fas fa-person-rifle', 'fas fa-person-drowning', 'fas fa-mosquito', 'fas fa-locust', 'fas fa-hurricane', 'fas fa-house-tsunami', 'fas fa-house-flood-water-circle-arrow-right', 'fas fa-house-flood-water', 'fas fa-house-fire', 'fas fa-house-crack', 'fas fa-house-chimney-crack', 'fas fa-hill-rockslide', 'fas fa-hill-avalanche', 'fas fa-helmet-un', 'fas fa-cloud-showers-water', 'fas fa-cloud-showers-heavy', 'fas fa-cloud-bolt', 'fas fa-circle-radiation', 'fas fa-child-combatant', 'fas fa-burst', 'fas fa-bugs', 'fas fa-biohazard',],
        'Editing': ['fas fa-check', 'fas fa-bars', 'fas fa-wand-magic-sparkles', 'fas fa-xmark', 'fas fa-pen-nib', 'fas fa-pen', 'fas fa-gear', 'fas fa-trash', 'fas fa-circle-half-stroke', 'fas fa-pen-to-square', 'far fa-pen-to-square', 'fas fa-plus', 'fas fa-minus', 'fas fa-eye-slash', 'far fa-eye-slash', 'fas fa-sliders', 'fas fa-brush', 'fas fa-link', 'fas fa-pen-fancy', 'fas fa-chart-simple', 'fas fa-pencil', 'fas fa-signature', 'fas fa-square-check', 'far fa-square-check', 'fas fa-cube', 'fas fa-circle-check', 'far fa-circle-check', 'fas fa-wand-magic', 'fas fa-trash-can-arrow-up', 'fas fa-trash-can', 'fas fa-trash-arrow-up', 'fas fa-square-pen', 'fas fa-scissors', 'fas fa-rotate', 'fas fa-pen-ruler', 'fas fa-pen-clip', 'fas fa-paintbrush', 'fas fa-link-slash', 'fas fa-grip-vertical', 'fas fa-grip-lines-vertical', 'fas fa-grip-lines', 'fas fa-grip', 'fas fa-eye-dropper', 'fas fa-ellipsis-vertical', 'fas fa-ellipsis', 'fas fa-delete-left', 'fas fa-crop-simple', 'fas fa-crop', 'fas fa-check-double', 'fas fa-bandage', 'fas fa-arrows-rotate', 'far fa-trash-can',],
        'Education': ['fas fa-music', 'fas fa-bell', 'far fa-bell', 'fas fa-school', 'fas fa-award', 'fas fa-chalkboard', 'fas fa-user-graduate', 'fas fa-shapes', 'fas fa-school-lock', 'fas fa-school-flag', 'fas fa-school-circle-xmark', 'fas fa-school-circle-exclamation', 'fas fa-school-circle-check', 'fas fa-person-chalkboard', 'fas fa-microscope', 'fas fa-masks-theater', 'fas fa-laptop-file', 'fas fa-laptop-code', 'fas fa-graduation-cap', 'fas fa-chalkboard-user', 'fas fa-book-open-reader', 'fas fa-book-open', 'fas fa-bell-slash', 'fas fa-atom', 'fas fa-apple-whole', 'far fa-bell-slash',],
        'Emoji': ['fas fa-face-smile', 'far fa-face-smile', 'fas fa-face-tired', 'fas fa-face-surprise', 'fas fa-face-smile-wink', 'fas fa-face-smile-beam', 'fas fa-face-sad-tear', 'fas fa-face-sad-cry', 'fas fa-face-rolling-eyes', 'fas fa-face-meh-blank', 'fas fa-face-meh', 'fas fa-face-laugh-wink', 'fas fa-face-laugh-squint', 'fas fa-face-laugh-beam', 'fas fa-face-laugh', 'fas fa-face-kiss-wink-heart', 'fas fa-face-kiss-beam', 'fas fa-face-kiss', 'fas fa-face-grin-wink', 'fas fa-face-grin-wide', 'fas fa-face-grin-tongue-wink', 'fas fa-face-grin-tongue-squint', 'fas fa-face-grin-tongue', 'fas fa-face-grin-tears', 'fas fa-face-grin-stars', 'fas fa-face-grin-squint-tears', 'fas fa-face-grin-squint', 'fas fa-face-grin-hearts', 'fas fa-face-grin-beam-sweat', 'fas fa-face-grin-beam', 'fas fa-face-grin', 'fas fa-face-grimace', 'fas fa-face-frown-open', 'fas fa-face-frown', 'fas fa-face-flushed', 'fas fa-face-dizzy', 'fas fa-face-angry', 'far fa-face-tired', 'far fa-face-surprise', 'far fa-face-smile-wink', 'far fa-face-smile-beam', 'far fa-face-sad-tear', 'far fa-face-sad-cry', 'far fa-face-rolling-eyes', 'far fa-face-meh-blank', 'far fa-face-meh', 'far fa-face-laugh-wink', 'far fa-face-laugh-squint', 'far fa-face-laugh-beam', 'far fa-face-laugh', 'far fa-face-kiss-wink-heart', 'far fa-face-kiss-beam', 'far fa-face-kiss', 'far fa-face-grin-wink', 'far fa-face-grin-wide', 'far fa-face-grin-tongue-wink', 'far fa-face-grin-tongue-squint', 'far fa-face-grin-tongue', 'far fa-face-grin-tears', 'far fa-face-grin-stars', 'far fa-face-grin-squint-tears', 'far fa-face-grin-squint', 'far fa-face-grin-hearts', 'far fa-face-grin-beam-sweat', 'far fa-face-grin-beam', 'far fa-face-grin', 'far fa-face-grimace', 'far fa-face-frown-open', 'far fa-face-frown', 'far fa-face-flushed', 'far fa-face-dizzy', 'far fa-face-angry',],
        'Energy': ['fas fa-bolt', 'fas fa-fire', 'fas fa-sun', 'far fa-sun', 'fas fa-water', 'fas fa-power-off', 'fas fa-leaf', 'fas fa-seedling', 'fas fa-plug', 'fas fa-wind', 'fas fa-lightbulb', 'far fa-lightbulb', 'fas fa-solar-panel', 'fas fa-industry', 'fas fa-tower-broadcast', 'fas fa-radiation', 'fas fa-poop', 'fas fa-plug-circle-xmark', 'fas fa-plug-circle-plus', 'fas fa-plug-circle-minus', 'fas fa-plug-circle-exclamation', 'fas fa-plug-circle-check', 'fas fa-plug-circle-bolt', 'fas fa-oil-well', 'fas fa-gas-pump', 'fas fa-fire-flame-simple', 'fas fa-fire-flame-curved', 'fas fa-fan', 'fas fa-explosion', 'fas fa-circle-radiation', 'fas fa-charging-station', 'fas fa-car-battery', 'fas fa-battery-three-quarters', 'fas fa-battery-quarter', 'fas fa-battery-half', 'fas fa-battery-full', 'fas fa-battery-empty', 'fas fa-atom', 'fas fa-arrow-up-from-ground-water',],
        'Files': ['fas fa-file', 'far fa-file', 'fas fa-folder', 'far fa-folder', 'fas fa-folder-open', 'far fa-folder-open', 'fas fa-copy', 'far fa-copy', 'fas fa-file-excel', 'far fa-file-excel', 'fas fa-file-export', 'fas fa-file-word', 'far fa-file-word', 'fas fa-file-import', 'fas fa-file-pdf', 'far fa-file-pdf', 'fas fa-clone', 'far fa-clone', 'fas fa-scissors', 'fas fa-photo-film', 'fas fa-paste', 'fas fa-note-sticky', 'fas fa-folder-closed', 'fas fa-floppy-disk', 'fas fa-file-zipper', 'fas fa-file-video', 'fas fa-file-shield', 'fas fa-file-powerpoint', 'fas fa-file-pen', 'fas fa-file-lines', 'fas fa-file-image', 'fas fa-file-csv', 'fas fa-file-code', 'fas fa-file-circle-xmark', 'fas fa-file-circle-question', 'fas fa-file-circle-plus', 'fas fa-file-circle-minus', 'fas fa-file-circle-exclamation', 'fas fa-file-circle-check', 'fas fa-file-audio', 'fas fa-file-arrow-up', 'fas fa-file-arrow-down', 'fas fa-box-archive', 'far fa-paste', 'far fa-note-sticky', 'far fa-folder-closed', 'far fa-floppy-disk', 'far fa-file-zipper', 'far fa-file-video', 'far fa-file-powerpoint', 'far fa-file-lines', 'far fa-file-image', 'far fa-file-code', 'far fa-file-audio',],
        'Film+Video': ['fab fa-youtube', 'fas fa-film', 'fas fa-headphones', 'fas fa-video', 'fas fa-ticket', 'fas fa-circle', 'far fa-circle', 'fas fa-video-slash', 'fas fa-audio-description', 'fas fa-closed-captioning', 'far fa-closed-captioning', 'fas fa-microphone-slash', 'fas fa-microphone', 'fas fa-tv', 'fas fa-tower-cell', 'fas fa-tower-broadcast', 'fas fa-square-rss', 'fas fa-podcast', 'fas fa-photo-film', 'fas fa-microphone-lines-slash', 'fas fa-microphone-lines', 'fas fa-file-video', 'fas fa-file-audio', 'fas fa-compact-disc', 'fas fa-clapperboard', 'far fa-file-video', 'far fa-file-audio',],
        'Food+Beverage': ['fas fa-mug-hot', 'fas fa-lemon', 'far fa-lemon', 'fas fa-flask', 'fas fa-fish', 'fas fa-mug-saucer', 'fas fa-seedling', 'fas fa-wine-bottle', 'fas fa-wine-glass-empty', 'fas fa-wine-glass', 'fas fa-whiskey-glass', 'fas fa-wheat-awn-circle-exclamation', 'fas fa-wheat-awn', 'fas fa-stroopwafel', 'fas fa-shrimp', 'fas fa-plate-wheat', 'fas fa-pizza-slice', 'fas fa-pepper-hot', 'fas fa-martini-glass-empty', 'fas fa-martini-glass-citrus', 'fas fa-martini-glass', 'fas fa-jar-wheat', 'fas fa-jar', 'fas fa-ice-cream', 'fas fa-hotdog', 'fas fa-glass-water-droplet', 'fas fa-glass-water', 'fas fa-fish-fins', 'fas fa-egg', 'fas fa-drumstick-bite', 'fas fa-cubes-stacked', 'fas fa-cookie', 'fas fa-cloud-meatball', 'fas fa-cheese', 'fas fa-champagne-glasses', 'fas fa-carrot', 'fas fa-candy-cane', 'fas fa-cake-candles', 'fas fa-burger', 'fas fa-bread-slice', 'fas fa-bowl-rice', 'fas fa-bowl-food', 'fas fa-bottle-water', 'fas fa-bottle-droplet', 'fas fa-bone', 'fas fa-blender', 'fas fa-beer-mug-empty', 'fas fa-bacon', 'fas fa-apple-whole',],
        'Fruits+Vegetables': ['fas fa-lemon', 'far fa-lemon', 'fas fa-leaf', 'fas fa-seedling', 'fas fa-pepper-hot', 'fas fa-carrot', 'fas fa-apple-whole',],
        'Gaming': ['fas fa-heart', 'far fa-heart', 'fas fa-shield-halved', 'fas fa-ghost', 'fas fa-gamepad', 'fas fa-diamond', 'fas fa-dragon', 'fas fa-scroll', 'fas fa-puzzle-piece', 'fas fa-dice', 'fas fa-ring', 'fas fa-headset', 'fab fa-playstation', 'fab fa-twitch', 'fas fa-wand-sparkles', 'fas fa-vr-cardboard', 'fas fa-square-full', 'fas fa-skull-crossbones', 'fas fa-hat-wizard', 'fas fa-hand-fist', 'fas fa-dungeon', 'fas fa-dice-two', 'fas fa-dice-three', 'fas fa-dice-six', 'fas fa-dice-one', 'fas fa-dice-four', 'fas fa-dice-five', 'fas fa-dice-d6', 'fas fa-dice-d20', 'fas fa-chess-rook', 'fas fa-chess-queen', 'fas fa-chess-pawn', 'fas fa-chess-knight', 'fas fa-chess-king', 'fas fa-chess-board', 'fas fa-chess-bishop', 'fas fa-chess', 'fas fa-book-skull', 'fab fa-xbox', 'fab fa-wizards-of-the-coast', 'fab fa-steam-symbol', 'fab fa-steam', 'fab fa-square-steam', 'fab fa-fantasy-flight-games', 'fab fa-d-and-d-beyond', 'fab fa-d-and-d', 'fab fa-critical-role', 'far fa-square-full', 'far fa-chess-rook', 'far fa-chess-queen', 'far fa-chess-pawn', 'far fa-chess-knight', 'far fa-chess-king', 'far fa-chess-bishop',],
        'Genders': ['fas fa-venus-mars', 'fas fa-venus-double', 'fas fa-venus', 'fas fa-transgender', 'fas fa-person-half-dress', 'fas fa-neuter', 'fas fa-mercury', 'fas fa-mars-stroke-up', 'fas fa-mars-stroke-right', 'fas fa-mars-stroke', 'fas fa-mars-double', 'fas fa-mars-and-venus', 'fas fa-mars', 'fas fa-genderless',],
        'Halloween': ['fas fa-ghost', 'fas fa-mask', 'fas fa-wand-sparkles', 'fas fa-toilet-paper', 'fas fa-spider', 'fas fa-skull-crossbones', 'fas fa-skull', 'fas fa-hat-wizard', 'fas fa-crow', 'fas fa-cloud-moon', 'fas fa-cat', 'fas fa-broom', 'fas fa-book-skull',],
        'Hands': ['fas fa-hand', 'far fa-hand', 'fas fa-thumbs-up', 'far fa-thumbs-up', 'fas fa-thumbs-down', 'far fa-thumbs-down', 'fas fa-handshake', 'far fa-handshake', 'fas fa-hand-holding-heart', 'fas fa-handshake-slash', 'fas fa-hand-point-up', 'far fa-hand-point-up', 'fas fa-handshake-simple-slash', 'fas fa-handshake-simple', 'fas fa-handshake-angle', 'fas fa-hands-praying', 'fas fa-hands-holding-circle', 'fas fa-hands-holding-child', 'fas fa-hands-holding', 'fas fa-hands-clapping', 'fas fa-hands-bubbles', 'fas fa-hands-bound', 'fas fa-hand-spock', 'fas fa-hand-sparkles', 'fas fa-hand-scissors', 'fas fa-hand-pointer', 'fas fa-hand-point-right', 'fas fa-hand-point-left', 'fas fa-hand-point-down', 'fas fa-hand-peace', 'fas fa-hand-middle-finger', 'fas fa-hand-lizard', 'fas fa-hand-holding-medical', 'fas fa-hand-holding-hand', 'fas fa-hand-holding-droplet', 'fas fa-hand-holding-dollar', 'fas fa-hand-holding', 'fas fa-hand-fist', 'fas fa-hand-dots', 'fas fa-hand-back-fist', 'far fa-hand-spock', 'far fa-hand-scissors', 'far fa-hand-pointer', 'far fa-hand-point-right', 'far fa-hand-point-left', 'far fa-hand-point-down', 'far fa-hand-peace', 'far fa-hand-lizard', 'far fa-hand-back-fist',],
        'Holidays': ['fas fa-heart', 'far fa-heart', 'fas fa-mug-hot', 'fas fa-gift', 'fas fa-cookie-bite', 'fas fa-snowman', 'fas fa-sleigh', 'fas fa-menorah', 'fas fa-holly-berry', 'fas fa-gifts', 'fas fa-face-kiss-wink-heart', 'fas fa-face-grin-hearts', 'fas fa-champagne-glasses', 'fas fa-carrot', 'fas fa-candy-cane', 'far fa-face-kiss-wink-heart', 'far fa-face-grin-hearts',],
        'Household': ['fas fa-bell', 'far fa-bell', 'fas fa-bath', 'fas fa-snowflake', 'far fa-snowflake', 'fas fa-mug-saucer', 'fas fa-door-open', 'fas fa-shower', 'fas fa-chair', 'fas fa-plug', 'fas fa-soap', 'fas fa-lightbulb', 'far fa-lightbulb', 'fas fa-utensils', 'fas fa-tv', 'fas fa-toilet-paper-slash', 'fas fa-toilet-paper', 'fas fa-toilet', 'fas fa-temperature-arrow-up', 'fas fa-temperature-arrow-down', 'fas fa-stairs', 'fas fa-spoon', 'fas fa-sink', 'fas fa-sheet-plastic', 'fas fa-rug', 'fas fa-pump-soap', 'fas fa-people-roof', 'fas fa-mattress-pillow', 'fas fa-kitchen-set', 'fas fa-jug-detergent', 'fas fa-jar-wheat', 'fas fa-jar', 'fas fa-house-user', 'fas fa-house-signal', 'fas fa-house-lock', 'fas fa-house-laptop', 'fas fa-house-fire', 'fas fa-house-chimney-window', 'fas fa-house-chimney-user', 'fas fa-fire-burner', 'fas fa-faucet-drip', 'fas fa-faucet', 'fas fa-fan', 'fas fa-dungeon', 'fas fa-door-closed', 'fas fa-couch', 'fas fa-computer', 'fas fa-box-tissue', 'fas fa-blender', 'fas fa-bed', 'fas fa-arrow-up-from-water-pump',],
        'Humanitarian': ['fas fa-envelope', 'far fa-envelope', 'fas fa-file', 'far fa-file', 'fas fa-car', 'fas fa-droplet', 'fas fa-truck', 'fas fa-wifi', 'fas fa-person', 'fas fa-person-dress', 'fas fa-snowflake', 'far fa-snowflake', 'fas fa-shop', 'fas fa-landmark', 'fas fa-shirt', 'fas fa-anchor', 'fas fa-stethoscope', 'fas fa-truck-front', 'fas fa-mountain-sun', 'fas fa-building', 'far fa-building', 'fas fa-flag', 'far fa-flag', 'fas fa-school', 'fas fa-laptop', 'fas fa-hotel', 'fas fa-walkie-talkie', 'fas fa-shower', 'fas fa-ship', 'fas fa-arrow-up-right-from-square', 'fas fa-seedling', 'fas fa-hammer', 'fas fa-file-pdf', 'far fa-file-pdf', 'fas fa-hospital', 'far fa-hospital', 'fas fa-virus', 'fas fa-radio', 'fas fa-plug', 'fas fa-road', 'fas fa-church', 'fas fa-soap', 'fas fa-wind', 'fas fa-baby', 'fas fa-people-arrows', 'fas fa-headset', 'fas fa-gopuram', 'fas fa-xmarks-lines', 'fas fa-worm', 'fas fa-wheelchair-move', 'fas fa-wheat-awn-circle-exclamation', 'fas fa-wheat-awn', 'fas fa-volcano', 'fas fa-virus-covid', 'fas fa-vihara', 'fas fa-vial-virus', 'fas fa-vial-circle-check', 'fas fa-users-viewfinder', 'fas fa-users-rectangle', 'fas fa-users-rays', 'fas fa-users-line', 'fas fa-users-between-lines', 'fas fa-user-injured', 'fas fa-user-doctor', 'fas fa-truck-plane', 'fas fa-truck-medical', 'fas fa-truck-field-un', 'fas fa-truck-field', 'fas fa-truck-droplet', 'fas fa-truck-arrow-right', 'fas fa-trowel-bricks', 'fas fa-trowel', 'fas fa-tree-city', 'fas fa-trash-can', 'fas fa-train-subway', 'fas fa-tower-observation', 'fas fa-tower-cell', 'fas fa-tower-broadcast', 'fas fa-tornado', 'fas fa-toilets-portable', 'fas fa-toilet-portable', 'fas fa-toilet', 'fas fa-tents', 'fas fa-tent-arrows-down', 'fas fa-tent-arrow-turn-left', 'fas fa-tent-arrow-left-right', 'fas fa-tent-arrow-down-to-line', 'fas fa-tent', 'fas fa-temperature-arrow-up', 'fas fa-temperature-arrow-down', 'fas fa-tarp-droplet', 'fas fa-tarp', 'fas fa-syringe', 'fas fa-sun-plant-wilt', 'fas fa-suitcase-medical', 'fas fa-staff-snake', 'fas fa-square-virus', 'fas fa-square-person-confined', 'fas fa-square-nfi', 'fas fa-skull-crossbones', 'fas fa-shop-lock', 'fas fa-shield-heart', 'fas fa-shield-dog', 'fas fa-shield-cat', 'fas fa-sheet-plastic', 'fas fa-school-lock', 'fas fa-school-flag', 'fas fa-school-circle-xmark', 'fas fa-school-circle-exclamation', 'fas fa-school-circle-check', 'fas fa-scale-balanced', 'fas fa-satellite-dish', 'fas fa-sailboat', 'fas fa-sack-xmark', 'fas fa-sack-dollar', 'fas fa-rug', 'fas fa-road-spikes', 'fas fa-road-lock', 'fas fa-road-circle-xmark', 'fas fa-road-circle-exclamation', 'fas fa-road-circle-check', 'fas fa-road-bridge', 'fas fa-road-barrier', 'fas fa-ranking-star', 'fas fa-radiation', 'fas fa-pump-soap', 'fas fa-plug-circle-xmark', 'fas fa-plug-circle-plus', 'fas fa-plug-circle-minus', 'fas fa-plug-circle-exclamation', 'fas fa-plug-circle-check', 'fas fa-plug-circle-bolt', 'fas fa-plate-wheat', 'fas fa-plant-wilt', 'fas fa-plane-up', 'fas fa-plane-lock', 'fas fa-plane-circle-xmark', 'fas fa-plane-circle-exclamation', 'fas fa-plane-circle-check', 'fas fa-pills', 'fas fa-person-walking-luggage', 'fas fa-person-walking-dashed-line-arrow-right', 'fas fa-person-walking-arrow-right', 'fas fa-person-walking-arrow-loop-left', 'fas fa-person-walking', 'fas fa-person-through-window', 'fas fa-person-shelter', 'fas fa-person-rifle', 'fas fa-person-rays', 'fas fa-person-pregnant', 'fas fa-person-military-to-person', 'fas fa-person-military-rifle', 'fas fa-person-military-pointing', 'fas fa-person-harassing', 'fas fa-person-half-dress', 'fas fa-person-falling-burst', 'fas fa-person-falling', 'fas fa-person-drowning', 'fas fa-person-dress-burst', 'fas fa-person-digging', 'fas fa-person-circle-xmark', 'fas fa-person-circle-question', 'fas fa-person-circle-plus', 'fas fa-person-circle-minus', 'fas fa-person-circle-exclamation', 'fas fa-person-circle-check', 'fas fa-person-chalkboard', 'fas fa-person-cane', 'fas fa-person-burst', 'fas fa-person-breastfeeding', 'fas fa-person-arrow-up-from-line', 'fas fa-person-arrow-down-to-line', 'fas fa-people-roof', 'fas fa-people-robbery', 'fas fa-people-pulling', 'fas fa-people-line', 'fas fa-people-group', 'fas fa-parachute-box', 'fas fa-oil-well', 'fas fa-mountain-city',],
        'Logistics': ['fas fa-truck-fast', 'fas fa-car', 'fas fa-gears', 'fas fa-truck', 'fas fa-chart-simple', 'fas fa-anchor', 'fas fa-truck-front', 'fas fa-train', 'fas fa-road', 'fas fa-warehouse', 'fas fa-xmarks-lines', 'fas fa-truck-plane', 'fas fa-truck-field-un', 'fas fa-truck-field', 'fas fa-truck-arrow-right', 'fas fa-train-subway', 'fas fa-square-nfi', 'fas fa-sailboat', 'fas fa-road-lock', 'fas fa-road-circle-xmark', 'fas fa-road-circle-exclamation', 'fas fa-road-circle-check', 'fas fa-road-bridge', 'fas fa-road-barrier', 'fas fa-plane-lock', 'fas fa-plane-circle-xmark', 'fas fa-plane-circle-exclamation', 'fas fa-plane-circle-check', 'fas fa-pallet', 'fas fa-jet-fighter-up', 'fas fa-helmet-safety', 'fas fa-helicopter-symbol', 'fas fa-helicopter', 'fas fa-gas-pump', 'fas fa-ferry', 'fas fa-dolly', 'fas fa-clipboard-question', 'fas fa-clipboard-list', 'fas fa-clipboard-check', 'fas fa-cart-flatbed', 'fas fa-car-tunnel', 'fas fa-bus-simple', 'fas fa-bus', 'fas fa-bridge-water', 'fas fa-bridge-lock', 'fas fa-bridge-circle-xmark', 'fas fa-bridge-circle-exclamation', 'fas fa-bridge-circle-check', 'fas fa-bridge', 'fas fa-boxes-stacked', 'fas fa-boxes-packing', 'fas fa-box', 'fas fa-anchor-lock', 'fas fa-anchor-circle-xmark', 'fas fa-anchor-circle-exclamation', 'fas fa-anchor-circle-check',],
        'Maps': ['fas fa-house', 'fas fa-magnifying-glass', 'fas fa-image', 'far fa-image', 'fas fa-phone', 'fas fa-location-dot', 'fas fa-music', 'fas fa-heart', 'far fa-heart', 'fas fa-bomb', 'fas fa-bell', 'far fa-bell', 'fas fa-cart-shopping', 'fas fa-circle-info', 'fas fa-car', 'fas fa-umbrella', 'fas fa-gift', 'fas fa-tag', 'fas fa-book', 'fas fa-bookmark', 'far fa-bookmark', 'fas fa-print', 'fas fa-droplet', 'fas fa-plus', 'fas fa-fire', 'fas fa-eye', 'far fa-eye', 'fas fa-eye-slash', 'far fa-eye-slash', 'fas fa-plane', 'fas fa-magnet', 'fas fa-money-bill', 'fas fa-lemon', 'far fa-lemon', 'fas fa-key', 'fas fa-thumbtack', 'fas fa-globe', 'fas fa-truck', 'fas fa-ticket', 'fas fa-tree', 'fas fa-wifi', 'fas fa-bicycle', 'fas fa-flask', 'fas fa-briefcase', 'fas fa-person', 'fas fa-bath', 'fas fa-binoculars', 'fas fa-layer-group', 'fas fa-gamepad', 'fas fa-mug-saucer', 'fas fa-landmark', 'fas fa-anchor', 'fas fa-bag-shopping', 'fas fa-mountain-sun', 'fas fa-location-pin', 'fas fa-info', 'fas fa-phone-volume', 'fas fa-street-view', 'fas fa-newspaper', 'far fa-newspaper', 'fas fa-building', 'far fa-building', 'fas fa-flag', 'far fa-flag', 'fas fa-flag-checkered', 'fas fa-tags', 'fas fa-rocket', 'fas fa-tty', 'fas fa-restroom', 'fas fa-leaf', 'fas fa-shower', 'fas fa-ship', 'fas fa-motorcycle', 'fas fa-train', 'fas fa-wrench', 'fas fa-trophy', 'fas fa-hospital', 'far fa-hospital', 'fas fa-route', 'fas fa-plug', 'fas fa-road', 'fas fa-crosshairs', 'fas fa-recycle', 'fas fa-lightbulb', 'far fa-lightbulb', 'fas fa-dollar-sign', 'fas fa-images', 'far fa-images', 'fas fa-industry', 'fas fa-wine-glass', 'fas fa-wheelchair-move', 'fas fa-wheelchair', 'fas fa-vest-patches', 'fas fa-vest', 'fas fa-utensils', 'fas fa-truck-medical', 'fas fa-train-tram', 'fas fa-train-subway', 'fas fa-traffic-light', 'fas fa-ticket-simple', 'fas fa-thumbtack-slash', 'fas fa-taxi', 'fas fa-suitcase-medical', 'fas fa-suitcase', 'fas fa-square-plus', 'fas fa-square-phone-flip', 'fas fa-square-phone', 'fas fa-square-parking', 'fas fa-square-h', 'fas fa-spoon', 'fas fa-snowplow', 'fas fa-signs-post', 'fas fa-shoe-prints', 'fas fa-scale-unbalanced-flip', 'fas fa-scale-unbalanced', 'fas fa-scale-balanced', 'fas fa-phone-flip', 'fas fa-person-walking-with-cane', 'fas fa-paw', 'fas fa-monument', 'fas fa-money-bill-1', 'fas fa-martini-glass-empty', 'fas fa-map-pin', 'fas fa-map', 'fas fa-magnifying-glass-plus', 'fas fa-magnifying-glass-minus', 'fas fa-magnifying-glass-location', 'fas fa-location-pin-lock', 'fas fa-location-crosshairs', 'fas fa-location-arrow', 'fas fa-life-ring', 'fas fa-landmark-flag', 'fas fa-jet-fighter', 'fas fa-helicopter-symbol', 'fas fa-helicopter', 'fas fa-heart-pulse', 'fas fa-graduation-cap', 'fas fa-gavel', 'fas fa-fire-flame-curved', 'fas fa-fire-extinguisher', 'fas fa-eye-low-vision', 'fas fa-draw-polygon', 'fas fa-diamond-turn-right', 'fas fa-cake-candles', 'fas fa-building-columns', 'fas fa-bridge-water', 'fas fa-bridge', 'fas fa-book-atlas', 'fas fa-bell-slash', 'fas fa-beer-mug-empty', 'fas fa-bed', 'fas fa-basket-shopping', 'far fa-square-plus', 'far fa-money-bill-1', 'far fa-map', 'far fa-life-ring', 'far fa-bell-slash',],
        'Maritime': ['fas fa-fish', 'fas fa-anchor', 'fas fa-water', 'fas fa-ship', 'fas fa-otter', 'fas fa-shrimp', 'fas fa-sailboat', 'fas fa-person-swimming', 'fas fa-fish-fins', 'fas fa-ferry', 'fas fa-anchor-lock', 'fas fa-anchor-circle-xmark', 'fas fa-anchor-circle-exclamation', 'fas fa-anchor-circle-check',],
        'Marketing': ['fas fa-chart-simple', 'fas fa-bullseye', 'fas fa-comments-dollar', 'fas fa-lightbulb', 'far fa-lightbulb', 'fas fa-timeline', 'fas fa-square-poll-vertical', 'fas fa-square-poll-horizontal', 'fas fa-rectangle-ad', 'fas fa-ranking-star', 'fas fa-person-rays', 'fas fa-people-group', 'fas fa-magnifying-glass-location', 'fas fa-magnifying-glass-dollar', 'fas fa-magnifying-glass-chart', 'fas fa-magnifying-glass-arrow-right', 'fas fa-group-arrows-rotate', 'fas fa-filter-circle-dollar', 'fas fa-envelopes-bulk', 'fas fa-envelope-open-text', 'fas fa-comment-dollar', 'fas fa-bullhorn', 'fas fa-arrows-to-eye', 'fas fa-arrows-to-dot', 'fas fa-arrows-spin',],
        'Mathematics': ['fas fa-circle-xmark', 'far fa-circle-xmark', 'fas fa-xmark', 'fas fa-plus', 'fas fa-minus', 'fas fa-square-xmark', 'fas fa-calculator', 'fas fa-percent', 'fas fa-square-minus', 'far fa-square-minus', 'fas fa-not-equal', 'fas fa-subscript', 'fas fa-wave-square', 'fas fa-superscript', 'fas fa-square-root-variable', 'fas fa-plus-minus', 'fas fa-less-than-equal', 'fas fa-less-than', 'fas fa-infinity', 'fas fa-greater-than-equal', 'fas fa-greater-than', 'fas fa-equals', 'fas fa-divide', 'fas fa-circle-plus', 'fas fa-circle-minus',],
        'Media Playback': ['fas fa-music', 'fas fa-rotate-right', 'fas fa-hand', 'far fa-hand', 'fas fa-sliders', 'fas fa-play', 'fas fa-backward', 'fas fa-phone-volume', 'fas fa-forward', 'fas fa-stop', 'fas fa-expand', 'fas fa-pause', 'fas fa-repeat', 'fas fa-volume-xmark', 'fas fa-volume-off', 'fas fa-volume-low', 'fas fa-volume-high', 'fas fa-up-right-and-down-left-from-center', 'fas fa-shuffle', 'fas fa-rss', 'fas fa-rotate-left', 'fas fa-rotate', 'fas fa-plus-minus', 'fas fa-minimize', 'fas fa-maximize', 'fas fa-forward-step', 'fas fa-forward-fast', 'fas fa-eject', 'fas fa-down-left-and-up-right-to-center', 'fas fa-compress', 'fas fa-circle-stop', 'fas fa-circle-play', 'fas fa-circle-pause', 'fas fa-backward-step', 'fas fa-backward-fast', 'fas fa-arrows-rotate', 'fas fa-arrow-rotate-right', 'fas fa-arrow-rotate-left', 'far fa-circle-stop', 'far fa-circle-play', 'far fa-circle-pause',],
        'Medical+Health': ['fas fa-heart', 'far fa-heart', 'fas fa-droplet', 'fas fa-plus', 'fas fa-eye', 'far fa-eye', 'fas fa-flask', 'fas fa-stethoscope', 'fas fa-notes-medical', 'fas fa-user-nurse', 'fas fa-vials', 'fas fa-brain', 'fas fa-star-of-life', 'fab fa-accessible-icon', 'fas fa-hospital', 'far fa-hospital', 'fas fa-virus', 'fas fa-joint', 'fas fa-receipt', 'fas fa-viruses', 'fas fa-tablets', 'fas fa-x-ray', 'fas fa-wheelchair-move', 'fas fa-wheelchair', 'fas fa-weight-scale', 'fas fa-virus-slash', 'fas fa-virus-covid-slash', 'fas fa-virus-covid', 'fas fa-vial-virus', 'fas fa-vial-circle-check', 'fas fa-vial', 'fas fa-user-doctor', 'fas fa-truck-medical', 'fas fa-truck-droplet', 'fas fa-tooth', 'fas fa-thermometer', 'fas fa-teeth-open', 'fas fa-teeth', 'fas fa-syringe', 'fas fa-suitcase-medical', 'fas fa-staff-snake', 'fas fa-square-virus', 'fas fa-square-plus', 'fas fa-square-h', 'fas fa-smoking', 'fas fa-skull-crossbones', 'fas fa-skull', 'fas fa-shield-virus', 'fas fa-radiation', 'fas fa-pump-medical', 'fas fa-prescription-bottle-medical', 'fas fa-prescription-bottle', 'fas fa-prescription', 'fas fa-poop', 'fas fa-pills', 'fas fa-person-half-dress', 'fas fa-person-dots-from-line', 'fas fa-person-cane', 'fas fa-person-breastfeeding', 'fas fa-pager', 'fas fa-mortar-pestle', 'fas fa-microscope', 'fas fa-mask-ventilator', 'fas fa-mask-face', 'fas fa-lungs-virus', 'fas fa-lungs', 'fas fa-laptop-medical', 'fas fa-kit-medical', 'fas fa-id-card-clip', 'fas fa-house-medical-flag', 'fas fa-house-medical-circle-xmark', 'fas fa-house-medical-circle-exclamation', 'fas fa-house-medical-circle-check', 'fas fa-house-medical', 'fas fa-house-chimney-medical', 'fas fa-hospital-user', 'fas fa-heart-pulse', 'fas fa-heart-circle-xmark', 'fas fa-heart-circle-plus', 'fas fa-heart-circle-minus', 'fas fa-heart-circle-exclamation', 'fas fa-heart-circle-check', 'fas fa-heart-circle-bolt', 'fas fa-head-side-virus', 'fas fa-head-side-mask', 'fas fa-head-side-cough-slash', 'fas fa-head-side-cough', 'fas fa-hand-holding-medical', 'fas fa-hand-holding-droplet', 'fas fa-hand-dots', 'fas fa-flask-vial', 'fas fa-fire-flame-simple', 'fas fa-file-waveform', 'fas fa-file-prescription', 'fas fa-file-medical', 'fas fa-eye-dropper', 'fas fa-droplet-slash', 'fas fa-dna', 'fas fa-disease', 'fas fa-crutch', 'fas fa-comment-medical', 'fas fa-clock-rotate-left', 'fas fa-clipboard-user', 'fas fa-circle-radiation', 'fas fa-circle-h', 'fas fa-capsules', 'fas fa-cannabis', 'fas fa-briefcase-medical', 'fas fa-book-medical', 'fas fa-bong', 'fas fa-bone', 'fas fa-biohazard', 'fas fa-bed-pulse', 'fas fa-bandage', 'fas fa-ban-smoking', 'fas fa-bacterium', 'fas fa-bacteria', 'far fa-square-plus',],
        'Money': ['fas fa-money-bill', 'fas fa-landmark', 'fas fa-credit-card', 'far fa-credit-card', 'fas fa-cash-register', 'fas fa-file-invoice', 'fas fa-wallet', 'fas fa-percent', 'fas fa-comments-dollar', 'fas fa-coins', 'fas fa-receipt', 'fas fa-dollar-sign', 'fas fa-stamp', 'fas fa-yen-sign', 'fas fa-won-sign', 'fas fa-vault', 'fas fa-turkish-lira-sign', 'fas fa-tenge-sign', 'fas fa-sterling-sign', 'fas fa-shekel-sign', 'fas fa-scale-unbalanced-flip', 'fas fa-scale-unbalanced', 'fas fa-scale-balanced', 'fas fa-sack-xmark', 'fas fa-sack-dollar', 'fas fa-rupiah-sign', 'fas fa-rupee-sign', 'fas fa-ruble-sign', 'fas fa-piggy-bank', 'fas fa-peso-sign', 'fas fa-peseta-sign', 'fas fa-naira-sign', 'fas fa-money-check-dollar', 'fas fa-money-check', 'fas fa-money-bills', 'fas fa-money-bill-wheat', 'fas fa-money-bill-wave', 'fas fa-money-bill-trend-up', 'fas fa-money-bill-transfer', 'fas fa-money-bill-1-wave', 'fas fa-money-bill-1', 'fas fa-mill-sign', 'fas fa-manat-sign', 'fas fa-litecoin-sign', 'fas fa-lira-sign', 'fas fa-lari-sign', 'fas fa-kip-sign', 'fas fa-indian-rupee-sign', 'fas fa-hryvnia-sign', 'fas fa-hand-holding-dollar', 'fas fa-guarani-sign', 'fas fa-franc-sign', 'fas fa-florin-sign', 'fas fa-file-invoice-dollar', 'fas fa-euro-sign', 'fas fa-dong-sign', 'fas fa-cruzeiro-sign', 'fas fa-comment-dollar', 'fas fa-colon-sign', 'fas fa-circle-dollar-to-slot', 'fas fa-chart-pie', 'fas fa-chart-line', 'fas fa-cent-sign', 'fas fa-cedi-sign', 'fas fa-brazilian-real-sign', 'fas fa-bitcoin-sign', 'fas fa-bangladeshi-taka-sign', 'fas fa-baht-sign', 'fas fa-austral-sign', 'fab fa-gg-circle', 'fab fa-gg', 'fab fa-ethereum', 'fab fa-btc', 'fab fa-bitcoin', 'far fa-money-bill-1',],
        'Moving': ['fas fa-route', 'fas fa-wine-glass', 'fas fa-truck-ramp-box', 'fas fa-truck-moving', 'fas fa-trailer', 'fas fa-tape', 'fas fa-suitcase', 'fas fa-sign-hanging', 'fas fa-people-carry-box', 'fas fa-house-chimney', 'fas fa-dolly', 'fas fa-couch', 'fas fa-caravan', 'fas fa-boxes-packing', 'fas fa-box-open', 'fas fa-box-archive',],
        'Music+Audio': ['fas fa-music', 'fas fa-headphones', 'fas fa-sliders', 'fab fa-soundcloud', 'fas fa-record-vinyl', 'fas fa-radio', 'fab fa-spotify', 'fas fa-microphone-slash', 'fas fa-microphone', 'fas fa-wave-square', 'fas fa-volume-xmark', 'fas fa-volume-off', 'fas fa-volume-low', 'fas fa-volume-high', 'fas fa-microphone-lines-slash', 'fas fa-microphone-lines', 'fas fa-headphones-simple', 'fas fa-guitar', 'fas fa-file-audio', 'fas fa-drum-steelpan', 'fas fa-drum', 'fas fa-compact-disc', 'fab fa-napster', 'far fa-file-audio',],
        'Nature': ['fas fa-fire', 'fas fa-tree', 'fas fa-binoculars', 'fas fa-feather', 'fas fa-bug', 'fas fa-mountain-sun', 'fas fa-water', 'fas fa-leaf', 'fas fa-seedling', 'fas fa-wind', 'fas fa-worm', 'fas fa-volcano', 'fas fa-spider', 'fas fa-signs-post', 'fas fa-plant-wilt', 'fas fa-person-hiking', 'fas fa-mountain-city', 'fas fa-mountain', 'fas fa-mound', 'fas fa-mosquito', 'fas fa-locust', 'fas fa-icicles', 'fas fa-frog', 'fas fa-feather-pointed', 'fas fa-clover', 'fas fa-cloud-sun', 'fas fa-cannabis', 'fas fa-bugs',],
        'Numbers': ['fas fa-9', 'fas fa-8', 'fas fa-7', 'fas fa-6', 'fas fa-5', 'fas fa-4', 'fas fa-3', 'fas fa-2', 'fas fa-1', 'fas fa-0',],
        'Photos+Images': ['fas fa-image', 'far fa-image', 'fas fa-camera-retro', 'fas fa-bolt', 'fas fa-film', 'fas fa-camera', 'fas fa-circle-half-stroke', 'fas fa-droplet', 'fas fa-eye', 'far fa-eye', 'fas fa-eye-slash', 'far fa-eye-slash', 'fas fa-sliders', 'fas fa-chalkboard', 'fas fa-clone', 'far fa-clone', 'fas fa-images', 'far fa-images', 'fas fa-photo-film', 'fas fa-panorama', 'fas fa-minimize', 'fas fa-image-portrait', 'fas fa-id-card', 'fas fa-id-badge', 'fas fa-file-image', 'fas fa-eye-dropper', 'fas fa-camera-rotate', 'fas fa-bolt-lightning', 'fab fa-unsplash', 'far fa-id-card', 'far fa-id-badge', 'far fa-file-image',],
        'Political': ['fas fa-dumpster-fire', 'fas fa-handshake', 'far fa-handshake', 'fas fa-award', 'fas fa-scale-unbalanced-flip', 'fas fa-scale-unbalanced', 'fas fa-scale-balanced', 'fas fa-republican', 'fas fa-piggy-bank', 'fas fa-person-booth', 'fas fa-landmark-flag', 'fas fa-landmark-dome', 'fas fa-hand-fist', 'fas fa-flag-usa', 'fas fa-dove', 'fas fa-democrat', 'fas fa-circle-dollar-to-slot', 'fas fa-check-to-slot', 'fas fa-check-double', 'fas fa-bullhorn', 'fas fa-building-flag',],
        'Punctuation+Symbols': ['fas fa-check', 'fas fa-plus', 'fas fa-minus', 'fas fa-circle-exclamation', 'fas fa-hashtag', 'fas fa-quote-left', 'fas fa-question', 'fas fa-quote-right', 'fas fa-exclamation', 'fas fa-percent', 'fas fa-section', 'fas fa-less-than', 'fas fa-greater-than', 'fas fa-equals', 'fas fa-circle-question', 'fas fa-check-double', 'fas fa-at', 'fas fa-asterisk', 'far fa-circle-question',],
        'Religion': ['fas fa-cross', 'fas fa-place-of-worship', 'fas fa-church', 'fas fa-gopuram', 'fas fa-yin-yang', 'fas fa-vihara', 'fas fa-torii-gate', 'fas fa-synagogue', 'fas fa-star-of-david', 'fas fa-star-and-crescent', 'fas fa-spaghetti-monster-flying', 'fas fa-scroll-torah', 'fas fa-person-praying', 'fas fa-peace', 'fas fa-om', 'fas fa-mosque', 'fas fa-menorah', 'fas fa-khanda', 'fas fa-kaaba', 'fas fa-jedi', 'fas fa-hanukiah', 'fas fa-hands-praying', 'fas fa-hamsa', 'fas fa-dove', 'fas fa-dharmachakra', 'fas fa-book-tanakh', 'fas fa-book-quran', 'fas fa-book-journal-whills', 'fas fa-book-bible', 'fas fa-bahai', 'fas fa-atom', 'fas fa-ankh',],
        'Science': ['fas fa-filter', 'fas fa-fire', 'fas fa-magnet', 'fas fa-flask', 'fas fa-vials', 'fas fa-brain', 'fas fa-seedling', 'fas fa-tablets', 'fas fa-vial-virus', 'fas fa-vial-circle-check', 'fas fa-vial', 'fas fa-temperature-low', 'fas fa-temperature-high', 'fas fa-syringe', 'fas fa-square-virus', 'fas fa-skull-crossbones', 'fas fa-radiation', 'fas fa-prescription-bottle', 'fas fa-pills', 'fas fa-mortar-pestle', 'fas fa-microscope', 'fas fa-frog', 'fas fa-flask-vial', 'fas fa-fire-flame-simple', 'fas fa-fire-flame-curved', 'fas fa-eye-dropper', 'fas fa-dna', 'fas fa-disease', 'fas fa-clipboard-check', 'fas fa-circle-radiation', 'fas fa-capsules', 'fas fa-biohazard', 'fas fa-atom',],
        'Science Fiction': ['fas fa-rocket', 'fas fa-robot', 'fas fa-user-astronaut', 'fas fa-jedi', 'fas fa-hand-spock', 'fas fa-explosion', 'fas fa-book-journal-whills', 'fas fa-atom', 'fab fa-space-awesome', 'fab fa-old-republic', 'fab fa-jedi-order', 'fab fa-galactic-senate', 'fab fa-galactic-republic', 'far fa-hand-spock',],
        'Security': ['fas fa-shield-halved', 'fas fa-lock', 'fas fa-eye', 'far fa-eye', 'fas fa-eye-slash', 'far fa-eye-slash', 'fas fa-key', 'fas fa-bug', 'fas fa-user-secret', 'fas fa-passport', 'fas fa-shield', 'fas fa-door-open', 'fas fa-file-contract', 'fas fa-mask', 'fas fa-fingerprint', 'fas fa-unlock', 'fas fa-vault', 'fas fa-user-shield', 'fas fa-user-lock', 'fas fa-unlock-keyhole', 'fas fa-tower-observation', 'fas fa-square-person-confined', 'fas fa-skull-crossbones', 'fas fa-shield-heart', 'fas fa-shield-dog', 'fas fa-shield-cat', 'fas fa-road-spikes', 'fas fa-person-through-window', 'fas fa-person-shelter', 'fas fa-person-rifle', 'fas fa-person-military-to-person', 'fas fa-person-military-rifle', 'fas fa-person-military-pointing', 'fas fa-person-harassing', 'fas fa-person-falling-burst', 'fas fa-person-dress-burst', 'fas fa-person-burst', 'fas fa-people-robbery', 'fas fa-people-pulling', 'fas fa-mars-and-venus-burst', 'fas fa-lock-open', 'fas fa-land-mine-on', 'fas fa-id-card-clip', 'fas fa-id-card', 'fas fa-id-badge', 'fas fa-house-lock', 'fas fa-house-fire', 'fas fa-hands-holding-circle', 'fas fa-hands-holding-child', 'fas fa-hands-bound', 'fas fa-handcuffs', 'fas fa-gun', 'fas fa-file-signature', 'fas fa-file-shield', 'fas fa-explosion', 'fas fa-dungeon', 'fas fa-door-closed', 'fas fa-car-on', 'fas fa-burst', 'fas fa-building-shield', 'fas fa-building-lock', 'fas fa-bug-slash', 'fas fa-ban', 'far fa-id-card', 'far fa-id-badge',],
        'Shapes': ['fas fa-star', 'far fa-star', 'fas fa-heart', 'far fa-heart', 'fas fa-cloud', 'fas fa-comment', 'far fa-comment', 'fas fa-file', 'far fa-file', 'fas fa-bookmark', 'far fa-bookmark', 'fas fa-circle-half-stroke', 'fas fa-folder', 'far fa-folder', 'fas fa-location-pin', 'fas fa-calendar', 'far fa-calendar', 'fas fa-circle', 'far fa-circle', 'fas fa-play', 'fas fa-square', 'far fa-square', 'fas fa-shield', 'fas fa-diamond', 'fas fa-crown', 'fas fa-certificate', 'fas fa-ticket-simple', 'fas fa-shapes', 'fas fa-lines-leaning', 'fas fa-heart-crack', 'fas fa-cubes-stacked', 'fas fa-clover', 'fas fa-burst',],
        'Shopping': ['fas fa-star', 'far fa-star', 'fas fa-heart', 'far fa-heart', 'fas fa-camera-retro', 'fas fa-truck-fast', 'fas fa-bell', 'far fa-bell', 'fas fa-cart-shopping', 'fas fa-gift', 'fab fa-stripe', 'fas fa-barcode', 'fas fa-tag', 'fas fa-bookmark', 'far fa-bookmark', 'fab fa-paypal', 'fas fa-camera', 'fas fa-thumbs-up', 'far fa-thumbs-up', 'fas fa-thumbs-down', 'far fa-thumbs-down', 'fas fa-key', 'fas fa-truck', 'fas fa-handshake', 'far fa-handshake', 'fas fa-shop', 'fas fa-shirt', 'fas fa-bag-shopping', 'fas fa-cart-plus', 'fas fa-credit-card', 'far fa-credit-card', 'fas fa-store', 'fas fa-cash-register', 'fas fa-tags', 'fab fa-cc-visa', 'fas fa-trophy', 'fas fa-certificate', 'fas fa-receipt', 'fab fa-cc-mastercard', 'fas fa-store-slash', 'fas fa-shop-slash', 'fas fa-shop-lock', 'fas fa-person-booth', 'fas fa-money-check-dollar', 'fas fa-money-check', 'fas fa-gifts', 'fas fa-gem', 'fas fa-cart-arrow-down', 'fas fa-bullhorn', 'fas fa-basket-shopping', 'fab fa-stripe-s', 'fab fa-nfc-symbol', 'fab fa-nfc-directional', 'fab fa-google-wallet', 'fab fa-google-pay', 'fab fa-ethereum', 'fab fa-cc-stripe', 'fab fa-cc-paypal', 'fab fa-cc-jcb', 'fab fa-cc-discover', 'fab fa-cc-diners-club', 'fab fa-cc-apple-pay', 'fab fa-cc-amex', 'fab fa-cc-amazon-pay', 'fab fa-btc', 'fab fa-bitcoin', 'fab fa-apple-pay', 'fab fa-amazon-pay', 'fab fa-alipay', 'far fa-gem',],
        'Social': ['fas fa-user', 'far fa-user', 'fab fa-facebook', 'fas fa-image', 'far fa-image', 'fas fa-envelope', 'far fa-envelope', 'fas fa-star', 'far fa-star', 'fas fa-location-dot', 'fas fa-heart', 'far fa-heart', 'fas fa-comment', 'far fa-comment', 'fas fa-bell', 'far fa-bell', 'fas fa-circle-user', 'far fa-circle-user', 'fas fa-camera', 'fas fa-video', 'fas fa-share-from-square', 'far fa-share-from-square', 'fas fa-share', 'fas fa-thumbs-up', 'far fa-thumbs-up', 'fas fa-thumbs-down', 'far fa-thumbs-down', 'fas fa-thumbtack', 'fas fa-hashtag', 'fas fa-users', 'fas fa-location-pin', 'fas fa-icons', 'fas fa-user-plus', 'fas fa-images', 'far fa-images', 'fas fa-user-group', 'fas fa-thumbtack-slash', 'fas fa-square-share-nodes', 'fas fa-square-poll-vertical', 'fas fa-square-poll-horizontal', 'fas fa-share-nodes', 'fas fa-retweet', 'fas fa-photo-film', 'fas fa-message', 'fas fa-cake-candles', 'fab fa-bluesky', 'fab fa-square-bluesky', 'far fa-message',],
        'Spinners': ['fas fa-gear', 'fas fa-rotate-right', 'fas fa-compass', 'far fa-compass', 'fas fa-snowflake', 'far fa-snowflake', 'fas fa-palette', 'fas fa-sun', 'far fa-sun', 'fas fa-spinner', 'fas fa-slash', 'fas fa-certificate', 'fas fa-crosshairs', 'fas fa-ring', 'fas fa-circle-notch', 'fas fa-yin-yang', 'fas fa-stroopwafel', 'fas fa-rotate-left', 'fas fa-rotate', 'fas fa-life-ring', 'fas fa-hurricane', 'fas fa-fan', 'fas fa-dharmachakra', 'fas fa-compact-disc', 'fas fa-bahai', 'fas fa-atom', 'fas fa-asterisk', 'fas fa-arrows-spin', 'fas fa-arrows-rotate', 'fas fa-arrow-rotate-right', 'fas fa-arrow-rotate-left', 'far fa-life-ring',],
        'Sports+Fitness': ['fas fa-heart', 'far fa-heart', 'fas fa-bicycle', 'fas fa-medal', 'fas fa-dumbbell', 'fas fa-weight-hanging', 'fas fa-volleyball', 'fas fa-table-tennis-paddle-ball', 'fas fa-stopwatch-20', 'fas fa-spa', 'fas fa-shoe-prints', 'fas fa-ranking-star', 'fas fa-person-walking', 'fas fa-person-swimming', 'fas fa-person-snowboarding', 'fas fa-person-skiing-nordic', 'fas fa-person-skiing', 'fas fa-person-skating', 'fas fa-person-running', 'fas fa-person-hiking', 'fas fa-person-biking', 'fas fa-mound', 'fas fa-hockey-puck', 'fas fa-heart-pulse', 'fas fa-golf-ball-tee', 'fas fa-futbol', 'fas fa-football', 'fas fa-fire-flame-simple', 'fas fa-fire-flame-curved', 'fas fa-broom-ball', 'fas fa-bowling-ball', 'fas fa-basketball', 'fas fa-baseball-bat-ball', 'fas fa-baseball', 'far fa-futbol',],
        'Text Formatting': ['fas fa-check', 'fas fa-list', 'fas fa-font', 'fas fa-strikethrough', 'fas fa-table', 'fas fa-icons', 'fas fa-square-check', 'far fa-square-check', 'fas fa-circle-check', 'far fa-circle-check', 'fas fa-heading', 'fas fa-i-cursor', 'fas fa-subscript', 'fas fa-border-none', 'fas fa-underline', 'fas fa-text-width', 'fas fa-text-slash', 'fas fa-text-height', 'fas fa-table-list', 'fas fa-table-columns', 'fas fa-table-cells-row-unlock', 'fas fa-table-cells-row-lock', 'fas fa-table-cells-large', 'fas fa-table-cells-column-lock', 'fas fa-table-cells', 'fas fa-superscript', 'fas fa-spell-check', 'fas fa-rectangle-list', 'fas fa-paragraph', 'fas fa-outdent', 'fas fa-list-ul', 'fas fa-list-ol', 'fas fa-list-check', 'fas fa-italic', 'fas fa-indent', 'fas fa-highlighter', 'fas fa-filter-circle-xmark', 'fas fa-check-double', 'fas fa-border-top-left', 'fas fa-border-all', 'fas fa-bold', 'fas fa-align-right', 'fas fa-align-left', 'fas fa-align-justify', 'fas fa-align-center', 'far fa-rectangle-list',],
        'Time': ['fas fa-calendar-days', 'far fa-calendar-days', 'fas fa-bell', 'far fa-bell', 'fas fa-calendar', 'far fa-calendar', 'fas fa-clock', 'far fa-clock', 'fas fa-hourglass-start', 'fas fa-calendar-week', 'fas fa-stopwatch-20', 'fas fa-stopwatch', 'fas fa-hourglass-half', 'fas fa-hourglass-end', 'fas fa-hourglass', 'fas fa-calendar-xmark', 'fas fa-calendar-plus', 'fas fa-calendar-minus', 'fas fa-calendar-day', 'fas fa-calendar-check', 'fas fa-bell-slash', 'far fa-hourglass-half', 'far fa-hourglass', 'far fa-calendar-xmark', 'far fa-calendar-plus', 'far fa-calendar-minus', 'far fa-calendar-check', 'far fa-bell-slash',],
        'Toggle': ['fas fa-star', 'far fa-star', 'fas fa-wifi', 'fas fa-circle', 'far fa-circle', 'fas fa-toggle-on', 'fas fa-signal', 'fas fa-bullseye', 'fas fa-circle-check', 'far fa-circle-check', 'fas fa-microphone-slash', 'fas fa-microphone', 'fas fa-toggle-off', 'fas fa-star-half-stroke', 'fas fa-star-half', 'fas fa-plane-up', 'fas fa-location-crosshairs', 'fas fa-circle-dot', 'far fa-star-half-stroke', 'far fa-star-half', 'far fa-circle-dot',],
        'Transportation': ['fas fa-cart-shopping', 'fas fa-car', 'fas fa-plane', 'fas fa-paper-plane', 'far fa-paper-plane', 'fas fa-truck', 'fas fa-bicycle', 'fas fa-car-side', 'fas fa-truck-front', 'fas fa-cable-car', 'fas fa-rocket', 'fas fa-ship', 'fas fa-motorcycle', 'fab fa-accessible-icon', 'fas fa-train', 'fas fa-road', 'fas fa-truck-monster', 'fas fa-wheelchair-move', 'fas fa-wheelchair', 'fas fa-van-shuttle', 'fas fa-truck-plane', 'fas fa-truck-pickup', 'fas fa-truck-medical', 'fas fa-truck-field-un', 'fas fa-truck-field', 'fas fa-truck-droplet', 'fas fa-truck-arrow-right', 'fas fa-train-tram', 'fas fa-train-subway', 'fas fa-tractor', 'fas fa-taxi', 'fas fa-snowplow', 'fas fa-sleigh', 'fas fa-shuttle-space', 'fas fa-sailboat', 'fas fa-road-spikes', 'fas fa-road-barrier', 'fas fa-plane-up', 'fas fa-plane-slash', 'fas fa-mound', 'fas fa-jet-fighter-up', 'fas fa-jet-fighter', 'fas fa-horse', 'fas fa-helicopter', 'fas fa-ferry', 'fas fa-car-tunnel', 'fas fa-car-rear', 'fas fa-car-burst', 'fas fa-bus-simple', 'fas fa-bus', 'fas fa-baby-carriage',],
        'Travel+Hotel': ['fas fa-car', 'fas fa-plane', 'fas fa-key', 'fas fa-wifi', 'fas fa-briefcase', 'fas fa-bath', 'fas fa-snowflake', 'far fa-snowflake', 'fas fa-earth-americas', 'fas fa-mug-saucer', 'fas fa-cable-car', 'fas fa-passport', 'fas fa-door-open', 'fas fa-hotel', 'fas fa-shower', 'fas fa-dice', 'fas fa-umbrella-beach', 'fas fa-dumbbell', 'fas fa-plane-departure', 'fas fa-wine-glass-empty', 'fas fa-wine-glass', 'fas fa-wheelchair-move', 'fas fa-wheelchair', 'fas fa-water-ladder', 'fas fa-van-shuttle', 'fas fa-utensils', 'fas fa-tv', 'fas fa-tree-city', 'fas fa-train-tram', 'fas fa-toilet-paper', 'fas fa-toilet', 'fas fa-taxi', 'fas fa-suitcase-rolling', 'fas fa-suitcase', 'fas fa-stairs', 'fas fa-spa', 'fas fa-smoking', 'fas fa-plane-up', 'fas fa-plane-slash', 'fas fa-plane-lock', 'fas fa-plane-circle-xmark', 'fas fa-plane-circle-exclamation', 'fas fa-plane-circle-check', 'fas fa-plane-arrival', 'fas fa-person-walking-luggage', 'fas fa-person-swimming', 'fas fa-mountain-city', 'fas fa-monument', 'fas fa-martini-glass-empty', 'fas fa-martini-glass-citrus', 'fas fa-martini-glass', 'fas fa-map-location-dot', 'fas fa-map-location', 'fas fa-map', 'fas fa-kitchen-set', 'fas fa-infinity', 'fas fa-hot-tub-person', 'fas fa-elevator', 'fas fa-earth-oceania', 'fas fa-earth-europe', 'fas fa-earth-asia', 'fas fa-earth-africa', 'fas fa-door-closed', 'fas fa-dice-five', 'fas fa-cart-flatbed-suitcase', 'fas fa-caravan', 'fas fa-bus-simple', 'fas fa-bus', 'fas fa-book-atlas', 'fas fa-bell-concierge', 'fas fa-bed', 'fas fa-ban-smoking', 'fas fa-baby-carriage', 'fas fa-archway', 'far fa-map',],
        'Users+People': ['fas fa-user', 'far fa-user', 'fas fa-poo', 'fas fa-face-smile', 'far fa-face-smile', 'fas fa-circle-user', 'far fa-circle-user', 'fas fa-person', 'fas fa-person-dress', 'fas fa-address-book', 'far fa-address-book', 'fas fa-users', 'fas fa-user-secret', 'fas fa-user-minus', 'fas fa-street-view', 'fas fa-address-card', 'far fa-address-card', 'fas fa-user-nurse', 'fas fa-restroom', 'fab fa-accessible-icon', 'fas fa-user-plus', 'fas fa-child', 'fas fa-user-tie', 'fas fa-baby', 'fas fa-people-arrows', 'fas fa-wheelchair-move', 'fas fa-wheelchair', 'fas fa-users-viewfinder', 'fas fa-users-slash', 'fas fa-users-rectangle', 'fas fa-users-rays', 'fas fa-users-line', 'fas fa-users-gear', 'fas fa-users-between-lines', 'fas fa-user-xmark', 'fas fa-user-tag', 'fas fa-user-slash', 'fas fa-user-shield', 'fas fa-user-pen', 'fas fa-user-ninja', 'fas fa-user-lock', 'fas fa-user-large-slash', 'fas fa-user-large', 'fas fa-user-injured', 'fas fa-user-group', 'fas fa-user-graduate', 'fas fa-user-gear', 'fas fa-user-doctor', 'fas fa-user-clock', 'fas fa-user-check', 'fas fa-user-astronaut', 'fas fa-square-person-confined', 'fas fa-skull', 'fas fa-person-walking-with-cane', 'fas fa-person-walking-luggage', 'fas fa-person-walking-dashed-line-arrow-right', 'fas fa-person-walking-arrow-right', 'fas fa-person-walking-arrow-loop-left', 'fas fa-person-walking', 'fas fa-person-through-window', 'fas fa-person-swimming', 'fas fa-person-snowboarding', 'fas fa-person-skiing-nordic', 'fas fa-person-skiing', 'fas fa-person-skating', 'fas fa-person-shelter', 'fas fa-person-running', 'fas fa-person-rifle', 'fas fa-person-rays', 'fas fa-person-pregnant', 'fas fa-person-praying', 'fas fa-person-military-to-person', 'fas fa-person-military-rifle', 'fas fa-person-military-pointing', 'fas fa-person-hiking', 'fas fa-person-harassing', 'fas fa-person-half-dress', 'fas fa-person-falling-burst', 'fas fa-person-falling', 'fas fa-person-drowning', 'fas fa-person-dress-burst', 'fas fa-person-dots-from-line', 'fas fa-person-digging', 'fas fa-person-circle-xmark', 'fas fa-person-circle-question', 'fas fa-person-circle-plus', 'fas fa-person-circle-minus', 'fas fa-person-circle-exclamation', 'fas fa-person-circle-check', 'fas fa-person-chalkboard', 'fas fa-person-cane', 'fas fa-person-burst', 'fas fa-person-breastfeeding', 'fas fa-person-booth', 'fas fa-person-biking', 'fas fa-person-arrow-up-from-line', 'fas fa-person-arrow-down-to-line', 'fas fa-people-roof', 'fas fa-people-robbery', 'fas fa-people-pulling', 'fas fa-people-line', 'fas fa-people-group', 'fas fa-people-carry-box', 'fas fa-mars-and-venus-burst', 'fas fa-image-portrait', 'fas fa-id-card-clip', 'fas fa-id-card', 'fas fa-id-badge', 'fas fa-house-user', 'fas fa-house-chimney-user', 'fas fa-hot-tub-person', 'fas fa-hospital-user', 'fas fa-head-side-virus', 'fas fa-head-side-mask', 'fas fa-head-side-cough-slash', 'fas fa-head-side-cough', 'fas fa-face-meh', 'fas fa-face-frown', 'fas fa-elevator', 'fas fa-clipboard-user', 'fas fa-children', 'fas fa-child-reaching', 'fas fa-child-dress', 'fas fa-chalkboard-user', 'fas fa-bed', 'fas fa-arrows-down-to-people', 'far fa-id-card', 'far fa-id-badge', 'far fa-face-meh', 'far fa-face-frown',],
        'Weather': ['fas fa-cloud', 'fas fa-bolt', 'fas fa-umbrella', 'fas fa-snowflake', 'far fa-snowflake', 'fas fa-sun', 'far fa-sun', 'fas fa-poo-storm', 'fas fa-water', 'fas fa-moon', 'far fa-moon', 'fas fa-wind', 'fas fa-volcano', 'fas fa-tornado', 'fas fa-temperature-three-quarters', 'fas fa-temperature-quarter', 'fas fa-temperature-low', 'fas fa-temperature-high', 'fas fa-temperature-half', 'fas fa-temperature-full', 'fas fa-temperature-empty', 'fas fa-temperature-arrow-up', 'fas fa-temperature-arrow-down', 'fas fa-sun-plant-wilt', 'fas fa-smog', 'fas fa-rainbow', 'fas fa-meteor', 'fas fa-icicles', 'fas fa-hurricane', 'fas fa-house-tsunami', 'fas fa-cloud-sun-rain', 'fas fa-cloud-sun', 'fas fa-cloud-showers-water', 'fas fa-cloud-showers-heavy', 'fas fa-cloud-rain', 'fas fa-cloud-moon-rain', 'fas fa-cloud-moon', 'fas fa-cloud-meatball', 'fas fa-cloud-bolt', 'fas fa-bolt-lightning',],
        'Writing': ['fas fa-envelope', 'far fa-envelope', 'fas fa-paperclip', 'fas fa-file', 'far fa-file', 'fas fa-pen', 'fas fa-book', 'fas fa-bookmark', 'far fa-bookmark', 'fas fa-pen-to-square', 'far fa-pen-to-square', 'fas fa-folder', 'far fa-folder', 'fas fa-folder-open', 'far fa-folder-open', 'fas fa-thumbtack', 'fas fa-paper-plane', 'far fa-paper-plane', 'fas fa-quote-left', 'fas fa-pencil', 'fas fa-newspaper', 'far fa-newspaper', 'fas fa-quote-right', 'fas fa-blog', 'fas fa-signature', 'fas fa-keyboard', 'far fa-keyboard', 'fas fa-eraser', 'fas fa-thumbtack-slash', 'fas fa-square-pen', 'fas fa-pen-clip', 'fas fa-paragraph', 'fas fa-note-sticky', 'fas fa-notdef', 'fas fa-file-lines', 'fas fa-envelope-open', 'fas fa-box-archive', 'fas fa-book-bookmark', 'far fa-note-sticky', 'far fa-file-lines', 'far fa-envelope-open',],
    };

    $.fn.wowIconPicker = function () {
        this.each(function (index, element) {
            $(element).fontIconPicker({
                source: icons,
                emptyIcon: false,
                allCategoryText: 'Show all',
                theme: 'fip-darkgrey',
            });
        });
    };

    $.fn.wowImageDownload = function () {

        const addon = $(this).find('.wpie-field__label.is-addon');
        $(addon).html('<span class="wpie-icon wpie_icon-file-download is-pointer"></span>');
        let custom_uploader;

        $(addon).off('click').on('click', function (e) {

            const parentElement = $(this).closest('.wpie-field__group');
            const input = $(parentElement).find('input');

            if (custom_uploader) {
                custom_uploader.open();
                return;
            }

            // wpie-field__group
            custom_uploader = wp.media.frames.file_frame = wp.media({
                title: 'Choose Image',
                button: {
                    text: 'Choose Image'
                },
                multiple: false  // Set to true to allow multiple files to be selected
            });

            // When an image is selected in the media manager...
            custom_uploader.on('select', function () {
                // Get media attachment details from the frame state
                let attachment = custom_uploader.state().get('selection').first().toJSON();

                // Send the attachment URL to our custom input field.
                $(input).val(attachment.url);

                $('#wpie-items-list .wpie-item').wowFloatMenuLiveBuilder();
            });


            // Open the media manager.
            custom_uploader.open();
        });

    };

});

