<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package non-profit-elementor
 */

?>
</div><!-- #main -->

<?php 
$display_copyright = get_theme_mod('non_profit_elementor_enable_cpright_footer_section',true);
$enable_scrolltop = get_theme_mod('non_profit_elementor_enable_scroll_top',true);
$copyright_content = get_theme_mod('non_profit_elementor_cpright_footer_section','Powered by WordPress');
?>

  <footer class="footer footer-one">
        <div class="foot-top">
            <div class="container">
                <div class="row">  
                  <?php if ( is_active_sidebar( 'footer-widgets' ) ) { ?>
                  
                    <div class="footer-top">
                        <div class="row clearfix">
                            <?php dynamic_sidebar('footer-widgets'); ?>      
                        </div>
                    </div>
                  
                  <?php } ?>

                </div>
                <div class="container">
                  <div class="row text-center">
                    <div class="col-md-12">
                      <?php if($display_copyright) { ?>
                      <div class="footer-credits">

                          <p class="footer-copyright">&copy;
                            <?php
                            echo esc_html(date_i18n(
                              /* translators: Copyright date format, see https://www.php.net/manual/datetime.format.php */
                              _x( 'Y', 'copyright date format', 'non-profit-elementor' )
                            ));
                            ?>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>
                          <!-- .footer-copyright -->

                          
                            <?php if($copyright_content == ""){ ?>
                            <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'non-profit-elementor' ) ); ?>">
                              <?php esc_html_e( 'Powered by WordPress', 'non-profit-elementor' ); ?>
                            </a>
                          <?php } else { ?>
                            <?php echo esc_html($copyright_content); ?>
                          <?php } ?>
                          </p><!-- .powered-by -->

                      </div><!-- .footer-credits -->
                    <?php } ?>  
                    </div>
                  </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- ====== Go to top ====== -->
    <?php if($enable_scrolltop) { ?>
    <a id="c-scroll" title="<?php esc_attr_e('Go to top','non-profit-elementor' ); ?>" href="javascript:void(0)">
      <i class="fa fa-long-arrow-up" aria-hidden="true"></i>
    </a>
    <?php } ?>
    
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
